package com.bwt.recipes.hopper_filter;

import com.bwt.blocks.BwtBlocks;
import com.bwt.generation.EmiDefaultsGenerator;
import com.bwt.recipes.BwtRecipes;
import com.bwt.utils.Id;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2119;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record HopperFilterRecipe(
        String group,
        class_7710 category,
        class_1856 ingredient,
        class_1856 filter,
        int soulCount,
        class_1799 result,
        class_1799 byproduct
) implements class_1860<HopperFilterRecipeInput> {
    @Override
    public class_1799 method_17447() {
        return new class_1799(BwtBlocks.hopperBlock);
    }

    @Override
    public class_1865<?> method_8119() {
        return BwtRecipes.HOPPER_FILTER_RECIPE_SERIALIZER;
    }

    @Override
    public boolean matches(HopperFilterRecipeInput input, class_1937 world) {
        return this.filter.method_8093(input.filterItem().method_7854()) && this.ingredient.method_8093(input.itemStack());
    }

    @Override
    public boolean method_8113(int width, int height) {
        return true;
    }

    @Override
    public String method_8112() {
        return this.group;
    }

    @Override
    public class_3956<?> method_17716() {
        return BwtRecipes.HOPPER_FILTER_RECIPE_TYPE;
    }

    public class_7710 getCategory() {
        return this.category;
    }

    @Override
    public boolean method_8118() {
        return class_1860.super.method_8118();
    }

    @Override
    public boolean method_49188() {
        return false;
    }

    @Override
    public class_1799 craft(HopperFilterRecipeInput input, class_7225.class_7874 lookup) {
        return method_8110(lookup);
    }

    @Override
    public class_1799 method_8110(class_7225.class_7874 wrapperLookup) {
        return result;
    }

    public static class Serializer implements class_1865<HopperFilterRecipe> {
        protected static final MapCodec<HopperFilterRecipe> CODEC = RecordCodecBuilder.mapCodec(
                instance->instance.group(
                        Codec.STRING.optionalFieldOf("group", "")
                                .forGetter(recipe -> recipe.group),
                        class_7710.field_40252.fieldOf("category")
                                .orElse(class_7710.field_40251)
                                .forGetter(recipe -> recipe.category),
                        class_1856.field_46096
                                .fieldOf("ingredient")
                                .forGetter(HopperFilterRecipe::ingredient),
                        class_1856.field_46096
                                .fieldOf("filter")
                                .forGetter(HopperFilterRecipe::filter),
                        Codec.INT.fieldOf("soulCount")
                                .forGetter(HopperFilterRecipe::soulCount),
                        class_1799.field_49266
                                .fieldOf("result")
                                .forGetter(HopperFilterRecipe::result),
                        class_1799.field_49266
                                .fieldOf("byproduct")
                                .forGetter(HopperFilterRecipe::byproduct)
                ).apply(instance, HopperFilterRecipe::new)
        );
        public static final class_9139<class_9129, HopperFilterRecipe> PACKET_CODEC = class_9139.method_56437(
                HopperFilterRecipe.Serializer::write, HopperFilterRecipe.Serializer::read
        );

        public Serializer() {
        }

        @Override
        public MapCodec<HopperFilterRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, HopperFilterRecipe> method_56104() {
            return PACKET_CODEC;
        }

        public static HopperFilterRecipe read(class_9129 buf) {
            String group = buf.method_19772();
            class_7710 category = buf.method_10818(class_7710.class);
            class_1856 ingredient = class_1856.field_48355.decode(buf);
            class_1856 filter = class_1856.field_48355.decode(buf);
            int soulCount = buf.method_10816();
            class_1799 result = class_1799.field_49268.decode(buf);
            class_1799 byproduct = class_1799.field_49268.decode(buf);
            return new HopperFilterRecipe(group, category, ingredient, filter, soulCount, result, byproduct);
        }

        public static void write(class_9129 buf, HopperFilterRecipe recipe) {
            buf.method_10814(recipe.group);
            buf.method_10817(recipe.category);
            class_1856.field_48355.encode(buf, recipe.ingredient);
            class_1856.field_48355.encode(buf, recipe.filter);
            buf.method_10804(recipe.soulCount);
            class_1799.field_49268.encode(buf, recipe.result);
            class_1799.field_49268.encode(buf, recipe.byproduct);
        }
    }

    public static class JsonBuilder implements class_5797 {
        protected class_7710 category = class_7710.field_40251;
        protected class_1856 ingredient;
        protected class_1856 filter;
        protected int soulCount;
        protected class_1799 result = class_1799.field_8037;
        protected class_1799 byproduct = class_1799.field_8037;
        @Nullable
        protected String group;

        public static HopperFilterRecipe.JsonBuilder create() {
            return new HopperFilterRecipe.JsonBuilder();
        }

        protected boolean isDefaultRecipe;
        public JsonBuilder markDefault() {
            this.isDefaultRecipe = true;
            return this;
        }
        public void addToDefaults(class_2960 recipeId) {
            if (this.isDefaultRecipe) {
                EmiDefaultsGenerator.addBwtRecipe(recipeId.method_45138("/"));
            }
        }

        public HopperFilterRecipe.JsonBuilder category(class_7710 category) {
            this.category = category;
            return this;
        }

        public HopperFilterRecipe.JsonBuilder ingredient(class_1856 ingredient) {
            this.ingredient = ingredient;
            return this;
        }

        public HopperFilterRecipe.JsonBuilder ingredient(class_1799 itemStack) {
            return this.ingredient(class_1856.method_8101(itemStack));
        }

        public HopperFilterRecipe.JsonBuilder ingredient(class_1792 item) {
            return this.ingredient(item.method_7854());
        }

        public HopperFilterRecipe.JsonBuilder filter(class_1856 filter) {
            this.filter = filter;
            return this;
        }

        public HopperFilterRecipe.JsonBuilder filter(class_1792 filter) {
            this.filter = class_1856.method_8091(filter);
            return this;
        }

        public HopperFilterRecipe.JsonBuilder filter(class_6862<class_1792> filter) {
            this.filter = class_1856.method_8106(filter);
            return this;
        }

        public HopperFilterRecipe.JsonBuilder soulCount(int soulCount) {
            this.soulCount = soulCount;
            return this;
        }

        public HopperFilterRecipe.JsonBuilder result(class_1799 itemStack) {
            this.result = itemStack;
            return this;
        }

        public HopperFilterRecipe.JsonBuilder result(class_1792 item, int count) {
            return this.result(new class_1799(item, count));
        }

        public HopperFilterRecipe.JsonBuilder result(class_1792 item) {
            return this.result(item, 1);
        }

        public HopperFilterRecipe.JsonBuilder byproduct(class_1799 itemStack) {
            this.byproduct = itemStack;
            return this;
        }

        public HopperFilterRecipe.JsonBuilder byproduct(class_1792 item, int count) {
            return this.byproduct(new class_1799(item, count));
        }

        public HopperFilterRecipe.JsonBuilder byproduct(class_1792 item) {
            return this.byproduct(item, 1);
        }

        @Override
        public HopperFilterRecipe.JsonBuilder method_33530(String string, class_175<?> advancementCriterion) {
            return this;
        }

        @Override
        public HopperFilterRecipe.JsonBuilder method_33529(@Nullable String string) {
            this.group = string;
            return this;
        }

        @Override
        public class_1792 method_36441() {
            return result.method_7909();
        }

        @Override
        public void method_10431(class_8790 exporter) {
            this.method_17972(
                    exporter,
                    Id.of("filter_" + class_2446.method_33716(this.ingredient.method_8105()[0].method_7909()))
            );
        }

        @Override
        public void method_36443(class_8790 exporter, String recipePath) {
            this.method_17972(exporter, Id.of(recipePath));
        }

        @Override
        public void method_17972(class_8790 exporter, class_2960 recipeId) {
            addToDefaults(recipeId);
            class_161.class_162 advancementBuilder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847(recipeId)).method_703(class_170.class_171.method_753(recipeId)).method_704(class_8782.class_8797.field_1257);
            HopperFilterRecipe hopperFilterRecipe = new HopperFilterRecipe(
                    Objects.requireNonNullElse(this.group, ""),
                    this.category,
                    this.ingredient,
                    this.filter,
                    this.soulCount,
                    this.result,
                    this.byproduct
            );
            exporter.method_53819(recipeId, hopperFilterRecipe, advancementBuilder.method_695(recipeId.method_45138("recipes/" + this.category.method_15434() + "/")));
        }
    }
}
