package com.bwt.recipes.soul_forge;

import com.bwt.generation.EmiDefaultsGenerator;
import com.bwt.mixin.accessors.ShapedRecipeJsonBuilderAccessorMixin;
import com.bwt.recipes.BwtRecipes;
import com.bwt.utils.Id;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2447;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5797;
import net.minecraft.class_7710;
import net.minecraft.class_7800;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_8957;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.recipe.*;
import java.util.Objects;

public class SoulForgeShapedRecipe extends class_1869 implements SoulForgeRecipe {
    protected class_8957 raw;

    public SoulForgeShapedRecipe(String group, class_7710 category, class_8957 raw, class_1799 result, boolean showNotification) {
        super(group, category, raw, result, showNotification);
        this.raw = raw;
    }

    @Override
    public class_1865<?> method_8119() {
        return BwtRecipes.SOUL_FORGE_SHAPED_RECIPE_SERIALIZER;
    }

    @Override
    public class_3956<?> method_17716() {
        return BwtRecipes.SOUL_FORGE_RECIPE_TYPE;
    }

    @Override
    public int method_8150() {
        return this.raw.method_59995();
    }

    @Override
    public int method_8158() {
        return this.raw.method_59996();
    }

    @Override
    public boolean method_8113(int width, int height) {
        return width >= this.raw.method_59995() && height >= this.raw.method_59996();
    }

    public class_8957 getRaw() {
        return raw;
    }

    public class_1799 getResult() {
        return method_8110(null);
    }

    public static class Serializer implements class_1865<SoulForgeShapedRecipe> {
        public static final MapCodec<SoulForgeShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(
                instance -> instance.group(
                        Codec.STRING.optionalFieldOf("group", "").forGetter(class_1869::method_8112),
                        class_7710.field_40252.fieldOf("category").orElse(class_7710.field_40251).forGetter(class_1869::method_45441),
                        RawSoulForgeShapedRecipe.CODEC.forGetter(SoulForgeShapedRecipe::getRaw),
                        class_1799.field_51397.fieldOf("result").forGetter(SoulForgeShapedRecipe::getResult),
                        Codec.BOOL.optionalFieldOf("show_notification", true).forGetter(class_1869::method_49188)
                ).apply(instance, SoulForgeShapedRecipe::new));
        public static final class_9139<class_9129, SoulForgeShapedRecipe> PACKET_CODEC = class_9139.method_56437(
                SoulForgeShapedRecipe.Serializer::write,
                SoulForgeShapedRecipe.Serializer::read
        );

        @Override
        public MapCodec<SoulForgeShapedRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, SoulForgeShapedRecipe> method_56104() {
            return PACKET_CODEC;
        }

        private static SoulForgeShapedRecipe read(class_9129 buf) {
            String string = buf.method_19772();
            class_7710 craftingRecipeCategory = buf.method_10818(class_7710.class);
            class_8957 rawShapedRecipe = class_8957.field_48359.decode(buf);
            class_1799 itemStack = class_1799.field_48349.decode(buf);
            boolean bl = buf.readBoolean();
            return new SoulForgeShapedRecipe(string, craftingRecipeCategory, rawShapedRecipe, itemStack, bl);
        }

        private static void write(class_9129 buf, SoulForgeShapedRecipe recipe) {
            buf.method_10814(recipe.method_8112());
            buf.method_10817(recipe.method_45441());
            class_8957.field_48359.encode(buf, recipe.raw);
            class_1799.field_48349.encode(buf, recipe.getResult());
            buf.method_52964(recipe.method_49188());
        }
    }

    public static class JsonBuilder extends class_2447 {
        public JsonBuilder(class_7800 category, class_1935 output, int count) {
            super(category, output, count);
        }

        public static JsonBuilder method_10437(class_7800 category, class_1935 output) {
            return JsonBuilder.method_10436(category, output, 1);
        }

        public static JsonBuilder method_10436(class_7800 category, class_1935 output, int count) {
            return new JsonBuilder(category, output, count);
        }

        protected boolean isDefaultRecipe;
        public JsonBuilder markDefault() {
            this.isDefaultRecipe = true;
            return this;
        }
        public void addToDefaults(class_2960 recipeId) {
            if (this.isDefaultRecipe) {
                EmiDefaultsGenerator.addBwtRecipe(recipeId.method_45138("/soulforge-bwt-"));
            }
        }

        private class_8957 method_10432(class_2960 recipeId) {
            ShapedRecipeJsonBuilderAccessorMixin accessor = ((ShapedRecipeJsonBuilderAccessorMixin) this);
            if (accessor.getCriteria().isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + recipeId);
            }
            return class_8957.method_55085(accessor.getInputs(), accessor.getPattern());
        }

        @Override
        public void method_36443(class_8790 exporter, String recipePath) {
            this.method_17972(exporter, Id.of(recipePath));
        }

        @Override
        public void method_17972(class_8790 exporter, class_2960 recipeId) {
            this.addToDefaults(recipeId);

            recipeId = Id.of(recipeId.method_12832());
            ShapedRecipeJsonBuilderAccessorMixin accessor = ((ShapedRecipeJsonBuilderAccessorMixin) this);
            class_8957 rawShapedRecipe = method_10432(recipeId);
            class_161.class_162 builder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847(recipeId)).method_703(class_170.class_171.method_753(recipeId)).method_704(class_8782.class_8797.field_1257);
            accessor.getCriteria().forEach(builder::method_705);
            SoulForgeShapedRecipe shapedRecipe = new SoulForgeShapedRecipe(Objects.requireNonNullElse(accessor.getGroup(), ""), class_5797.method_55308(accessor.getCategory()), rawShapedRecipe, new class_1799(accessor.getOutput(), accessor.getCount()), accessor.getShowNotification());
            exporter.method_53819(recipeId, shapedRecipe, builder.method_695(recipeId.method_45138("recipes/" + accessor.getCategory().method_46203() + "/")));
        }
    }
}

