package com.bwt.utils;

import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;

public class BlockUtils {
    public static class_265 rotateCuboidFromUp(class_2350 direction, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        float deg_90 = ((float) Math.PI) / 2f;
        class_243 half = new class_243(8, 8, 8);

        // Shift to center of block for rotation
        class_243 minPos = new class_243(xMin, yMin, zMin).method_1020(half);
        class_243 maxPos = new class_243(xMax, yMax, zMax).method_1020(half);

        switch (direction) {
            case field_11036:
                break;
            case field_11033:
                minPos = minPos.method_31033(2 * deg_90);
                maxPos = maxPos.method_31033(2 * deg_90);
                break;
            case field_11043:
                minPos = minPos.method_1037(deg_90);
                maxPos = maxPos.method_1037(deg_90);
                break;
            case field_11035:
                minPos = minPos.method_1037(-deg_90);
                maxPos = maxPos.method_1037(-deg_90);
                break;
            case field_11034:
                minPos = minPos.method_31033(deg_90);
                maxPos = maxPos.method_31033(deg_90);
                break;
            case field_11039:
                minPos = minPos.method_31033(-deg_90);
                maxPos = maxPos.method_31033(-deg_90);
                break;
        }

        minPos = minPos.method_1019(half);
        maxPos = maxPos.method_1019(half);
        return class_2248.method_9541(
                Math.min(minPos.method_10216(), maxPos.method_10216()),
                Math.min(minPos.method_10214(), maxPos.method_10214()),
                Math.min(minPos.method_10215(), maxPos.method_10215()),
                Math.max(minPos.method_10216(), maxPos.method_10216()),
                Math.max(minPos.method_10214(), maxPos.method_10214()),
                Math.max(minPos.method_10215(), maxPos.method_10215())
        );
    }

    public static class_265 rotateCuboidFromUp(class_2350 direction, class_238 box) {
        return rotateCuboidFromUp(direction, box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324);
    }

    public static class_265 rotateCuboid(class_2350 fromDirection, class_2350 toDirection, class_238 box) {
        // Rotate source to up direction via opposite direction
        class_265 shape = rotateCuboidFromUp(fromDirection.method_10166().method_10178() ? fromDirection : fromDirection.method_10153(), box);
        // Rotate
        return rotateCuboidFromUp(toDirection, shape.method_1107());
    }
}
