package com.bwt.utils;

import com.bwt.blocks.StokedFireBlock;
import com.bwt.tags.BwtBlockTags;
import java.util.HashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;

public class FireData {
    public interface FireAmountFunction {
        FireAmountFunction DEFAULT = (world, pos, state) -> {
            FireData data = new FireData();
            if (state.method_26164(BwtBlockTags.HEATS_COOKING_STATIONS)) {
                data.unstokedCount += 1;
            }
            else if (state.method_26164(BwtBlockTags.HEATS_COOKING_STATIONS_WHEN_LIT) && state.method_28500(class_2741.field_12548).orElse(false)) {
                data.unstokedCount += 1;
            }

            if (state.method_26164(BwtBlockTags.STOKES_COOKING_STATIONS)) {
                data.stokedCount += 1;
            }
            else if (state.method_26164(BwtBlockTags.STOKES_COOKING_STATIONS_WHEN_LIT) && state.method_28500(class_2741.field_12548).orElse(false)) {
                data.stokedCount += 1;
            }
            return data;
        };

        FireData getFireData(class_1937 world, class_2338 pos, class_2680 state);
    }

    public static final HashMap<Class<? extends class_2248>, FireAmountFunction> FIRE_AMOUNT_FUNCTIONS = new HashMap<>();

    int unstokedCount;
    int stokedCount;

    public FireData(int unstokedCount, int stokedCount) {
        this.unstokedCount = unstokedCount;
        this.stokedCount = stokedCount;
    }

    public FireData(int unstokedCount) {
        this(unstokedCount, 0);
    }

    public FireData() {
        this(0);
    }

    public void add(FireData otherData) {
        this.unstokedCount += otherData.unstokedCount;
        this.stokedCount += otherData.stokedCount;
    }

    public boolean anyFirePresent() {
        return unstokedCount > 0 || stokedCount > 0;
    }

    public int getUnstokedCount() {
        return unstokedCount;
    }

    public int getStokedCount() {
        return stokedCount;
    }

}