/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks;

import com.bwt.blocks.ColumnBlock;
import com.bwt.blocks.CornerBlock;
import com.bwt.blocks.MouldingBlock;
import com.bwt.blocks.PedestalBlock;
import com.bwt.blocks.SidingBlock;
import com.bwt.blocks.TableBlock;
import com.bwt.utils.Id;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import net.minecraft.class_7923;

public abstract class MaterialInheritedBlock
extends class_2248 {
    public class_2248 fullBlock;
    public boolean isWood = false;

    public MaterialInheritedBlock(class_4970.class_2251 settings, class_2248 fullBlock) {
        super(settings);
        this.fullBlock = fullBlock;
    }

    public boolean isWood() {
        return this.isWood;
    }

    public static void registerMaterialBlocks(ArrayList<SidingBlock> sidingBlocks, ArrayList<MouldingBlock> mouldingBlocks, ArrayList<CornerBlock> cornerBlocks, ArrayList<ColumnBlock> columnBlocks, ArrayList<PedestalBlock> pedestalBlocks, ArrayList<TableBlock> tableBlocks) {
        Stream.concat(class_4719.method_24026().map(woodType -> class_7923.field_41175.method_17966(Id.mc(woodType.comp_1299() + "_planks"))).filter(Optional::isPresent).map(Optional::get), Stream.of(class_2246.field_40295)).forEach(block -> {
            sidingBlocks.add(SidingBlock.ofWoodBlock(block));
            mouldingBlocks.add(MouldingBlock.ofWoodBlock(block));
            cornerBlocks.add(CornerBlock.ofWoodBlock(block));
            columnBlocks.add(ColumnBlock.ofWoodBlock(block));
            pedestalBlocks.add(PedestalBlock.ofWoodBlock(block));
            tableBlocks.add(TableBlock.ofWoodBlock(block));
        });
        List<class_5794> blockFamilies = List.of(class_5793.field_28523, class_5793.field_28497, class_5793.field_28498, class_5793.field_28515, class_5793.field_28491, class_5793.field_28494, class_5793.field_28513, class_5793.field_28483, class_5793.field_28525, class_5793.field_28480, class_5793.field_28508, class_5793.field_28509, class_5793.field_28481, class_5793.field_28482, class_5793.field_29079, class_5793.field_47131, class_5793.field_38008, class_5793.field_28485, class_5793.field_28514, class_5793.field_28486);
        blockFamilies.stream().map(class_5794::method_33469).forEach(block -> {
            sidingBlocks.add(SidingBlock.ofBlock(block));
            mouldingBlocks.add(MouldingBlock.ofBlock(block));
            cornerBlocks.add(CornerBlock.ofBlock(block));
            columnBlocks.add(ColumnBlock.ofBlock(block));
            pedestalBlocks.add(PedestalBlock.ofBlock(block));
            tableBlocks.add(TableBlock.ofBlock(block));
        });
        for (int i = 0; i < sidingBlocks.size(); ++i) {
            SidingBlock sidingBlock = sidingBlocks.get(i);
            MouldingBlock mouldingBlock = mouldingBlocks.get(i);
            CornerBlock cornerBlock = cornerBlocks.get(i);
            ColumnBlock columnBlock = columnBlocks.get(i);
            PedestalBlock pedestalBlock = pedestalBlocks.get(i);
            TableBlock tableBlock = tableBlocks.get(i);
            class_2960 blockId = class_7923.field_41175.method_10221((Object)sidingBlock.fullBlock);
            class_2960 sidingId = Id.of(blockId.method_12832() + "_siding");
            class_2960 mouldingId = Id.of(blockId.method_12832() + "_moulding");
            class_2960 cornerId = Id.of(blockId.method_12832() + "_corner");
            class_2960 columnId = Id.of(blockId.method_12832() + "_column");
            class_2960 pedestalId = Id.of(blockId.method_12832() + "_pedestal");
            class_2960 tableId = Id.of(blockId.method_12832() + "_table");
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)sidingId, (Object)sidingBlock);
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)mouldingId, (Object)mouldingBlock);
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)cornerId, (Object)cornerBlock);
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)columnId, (Object)((Object)columnBlock));
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)pedestalId, (Object)((Object)pedestalBlock));
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)tableId, (Object)((Object)tableBlock));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)sidingId, (Object)new class_1747((class_2248)sidingBlock, new class_1792.class_1793()));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)mouldingId, (Object)new class_1747((class_2248)mouldingBlock, new class_1792.class_1793()));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)cornerId, (Object)new class_1747((class_2248)cornerBlock, new class_1792.class_1793()));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)columnId, (Object)new class_1747((class_2248)columnBlock, new class_1792.class_1793()));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)pedestalId, (Object)new class_1747((class_2248)pedestalBlock, new class_1792.class_1793()));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)tableId, (Object)new class_1747((class_2248)tableBlock, new class_1792.class_1793()));
        }
    }
}

