/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks;

import com.bwt.blocks.AxleBlock;
import com.bwt.blocks.HandCrankBlock;
import com.bwt.sounds.BwtSoundEvents;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3419;

public interface MechPowerBlockBase {
    public static final int turnOnTickRate = 10;
    public static final int turnOffTickRate = 9;
    public static final class_2746 MECH_POWERED = class_2746.method_11825((String)"mech_powered");

    public static int getTurnOnTickRate() {
        return 10;
    }

    public static int getTurnOffTickRate() {
        return 9;
    }

    default public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{MECH_POWERED});
    }

    default public boolean isMechPowered(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)MECH_POWERED);
    }

    default public Predicate<class_2350> getValidAxleInputFaces(class_2680 blockState, class_2338 pos) {
        return direction -> true;
    }

    default public Predicate<class_2350> getValidHandCrankFaces(class_2680 blockState, class_2338 pos) {
        return direction -> !direction.equals((Object)class_2350.field_11033);
    }

    default public Stream<class_2350> getPowerInputFaces(class_1937 world, class_2338 pos, class_2680 blockState) {
        Predicate<class_2350> axlePredicate = this.getValidAxleInputFaces(blockState, pos);
        Predicate<class_2350> handCrankPredicate = this.getValidHandCrankFaces(blockState, pos);
        return Arrays.stream(class_2350.values()).filter(direction -> {
            class_2680 inputBlockState = world.method_8320(pos.method_10093(direction));
            return axlePredicate.test((class_2350)direction) && inputBlockState.method_26204() instanceof AxleBlock && AxleBlock.isPowered(inputBlockState) && ((class_2350.class_2351)inputBlockState.method_11654((class_2769)AxleBlock.field_11459)).method_10176(direction) || handCrankPredicate.test((class_2350)direction) && inputBlockState.method_26204() instanceof HandCrankBlock && HandCrankBlock.isPowered(inputBlockState);
        });
    }

    default public boolean isReceivingMechPower(class_1937 world, class_2680 blockState, class_2338 pos) {
        return this.getPowerInputFaces(world, pos, blockState).findAny().isPresent();
    }

    default public boolean isOverPowered(class_1937 world, class_2680 blockState, class_2338 pos) {
        return this.getPowerInputFaces(world, pos, blockState).limit(2L).count() > 1L;
    }

    default public void playBangSound(class_1937 world, class_2338 pos, float volume, float pitch) {
        world.method_8396(null, pos, BwtSoundEvents.MECH_BANG, class_3419.field_15245, volume, pitch);
    }

    default public void playBangSound(class_1937 world, class_2338 pos, float volume) {
        this.playBangSound(world, pos, volume, 1.0f);
    }

    default public void playBangSound(class_1937 world, class_2338 pos) {
        this.playBangSound(world, pos, 0.5f);
    }

    default public void playCreakSound(class_1937 world, class_2338 pos, float volume) {
        world.method_8396(null, pos, BwtSoundEvents.MECH_CREAK, class_3419.field_15245, volume, world.field_9229.method_43057() * 0.25f + 0.25f);
    }

    default public void playCreakSound(class_1937 world, class_2338 pos) {
        this.playCreakSound(world, pos, 0.25f);
    }
}

