/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks.abstract_cooking_pot;

import com.bwt.blocks.MechPowerBlockBase;
import com.bwt.blocks.abstract_cooking_pot.AbstractCookingPotBlockEntity;
import com.bwt.utils.BlockUtils;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCookingPotBlock
extends class_2237
implements MechPowerBlockBase {
    public static final class_2753 TIP_DIRECTION = class_2753.method_11844((String)"tip_direction", direction -> direction != class_2350.field_11033);
    public static class_238 box1 = new class_238(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);
    public static class_238 box2 = new class_238(0.0, 2.0, 0.0, 16.0, 14.0, 16.0);
    protected static final List<class_265> COLLISION_SHAPES = Arrays.stream(class_2350.values()).map(direction -> class_259.method_1084((class_265)BlockUtils.rotateCuboidFromUp(direction, box1), (class_265)BlockUtils.rotateCuboidFromUp(direction, box2)).method_1097()).toList();
    protected static final class_265 SIDES_SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public AbstractCookingPotBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)TIP_DIRECTION, (Comparable)class_2350.field_11036)).method_11657((class_2769)MECH_POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        MechPowerBlockBase.super.method_9515(builder);
        builder.method_11667(new class_2769[]{TIP_DIRECTION});
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return null;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return COLLISION_SHAPES.get(((class_2350)state.method_11654((class_2769)TIP_DIRECTION)).method_10146());
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_1077();
    }

    public class_265 method_25959(class_2680 state, class_1922 world, class_2338 pos) {
        return SIDES_SHAPE;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_1264.method_54291((class_2680)state, (class_2680)newState, (class_1937)world, (class_2338)pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    public Predicate<class_2350> getValidAxleInputFaces(class_2680 blockState, class_2338 pos) {
        return direction -> direction.method_10166().method_10179();
    }

    @Override
    public Predicate<class_2350> getValidHandCrankFaces(class_2680 blockState, class_2338 pos) {
        return this.getValidAxleInputFaces(blockState, pos);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        this.schedulePowerUpdate(state, world, pos);
    }

    public void schedulePowerUpdate(class_2680 state, class_1937 world, class_2338 pos) {
        boolean isMechPowered;
        boolean bl = isMechPowered = this.getPowerInputFaces(world, pos, state).count() == 1L;
        if (isMechPowered && !this.isMechPowered(state)) {
            world.method_39279(pos, (class_2248)this, MechPowerBlockBase.getTurnOnTickRate());
        } else if (!isMechPowered && this.isMechPowered(state)) {
            world.method_39279(pos, (class_2248)this, MechPowerBlockBase.getTurnOffTickRate());
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        this.schedulePowerUpdate(state, world, pos);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        Optional input = this.getPowerInputFaces((class_1937)world, pos, state).findFirst();
        if (input.isPresent() == this.isMechPowered(state)) {
            return;
        }
        if (input.isEmpty()) {
            world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)TIP_DIRECTION, (Comparable)class_2350.field_11036)).method_11657((class_2769)MECH_POWERED, (Comparable)Boolean.valueOf(false)));
            return;
        }
        world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)TIP_DIRECTION, (Comparable)((class_2350)input.get()).method_10170())).method_11657((class_2769)MECH_POWERED, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    protected static <A extends class_2586, E extends AbstractCookingPotBlockEntity> class_5558<A> validateTicker(class_1937 world, class_2591<A> givenType, class_2591<E> expectedType) {
        return world.field_9236 ? null : class_2237.method_31618(givenType, expectedType, AbstractCookingPotBlockEntity::tick);
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (world.field_9236) {
            return;
        }
        if (state.method_11654((class_2769)TIP_DIRECTION) != class_2350.field_11036) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof AbstractCookingPotBlockEntity) {
            AbstractCookingPotBlockEntity cookingPotBlockEntity = (AbstractCookingPotBlockEntity)blockEntity;
            AbstractCookingPotBlockEntity.onEntityCollided(entity, cookingPotBlockEntity);
        }
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)TIP_DIRECTION, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)TIP_DIRECTION)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657((class_2769)TIP_DIRECTION, (Comparable)mirror.method_10343((class_2350)state.method_11654((class_2769)TIP_DIRECTION)));
    }
}

