/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks.block_dispenser;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.block_entities.ImplementedInventory;
import com.bwt.blocks.block_dispenser.BlockDispenserScreenHandler;
import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2601;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class BlockDispenserBlockEntity
extends class_2601
implements class_3908,
ImplementedInventory,
class_1278 {
    public static final int INVENTORY_SIZE = 16;
    private static final int[] AVAILABLE_SLOTS = IntStream.range(0, 16).toArray();
    private int selectedSlot;
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return BlockDispenserBlockEntity.this.selectedSlot;
        }

        public void method_17391(int index, int value) {
            BlockDispenserBlockEntity.this.selectedSlot = value;
        }

        public int method_17389() {
            return 1;
        }
    };

    public BlockDispenserBlockEntity(class_2338 pos, class_2680 state) {
        super(BwtBlockEntities.blockDispenserBlockEntity, pos, state);
        this.method_11281(class_2371.method_10213((int)16, (Object)class_1799.field_8037));
        this.selectedSlot = 0;
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    public void setSelectedSlot(int slotToSelect) {
        this.selectedSlot = Math.max(slotToSelect, 0) % 16;
        this.method_5431();
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.method_11282();
    }

    @Override
    public int method_5439() {
        return 16;
    }

    protected int findNextValidSlotIndex() {
        int invSize = this.method_11282().size();
        for (int currentSlot = this.selectedSlot + 1; currentSlot <= invSize + this.selectedSlot; ++currentSlot) {
            if (((class_1799)this.method_11282().get(currentSlot % invSize)).method_7960()) continue;
            return currentSlot % invSize;
        }
        return 0;
    }

    public void advanceSelectedSlot() {
        this.setSelectedSlot(this.findNextValidSlotIndex());
    }

    public class_1799 getCurrentItemToDispense() {
        class_1799 itemStack = (class_1799)this.method_11282().get(this.selectedSlot);
        if (!itemStack.method_7960()) {
            return itemStack;
        }
        int newSlot = this.findNextValidSlotIndex();
        this.setSelectedSlot(newSlot);
        return (class_1799)this.method_11282().get(newSlot);
    }

    public boolean hasRoomFor(class_1799 stack) {
        int count = stack.method_7947();
        for (class_1799 invStack : this.method_11282()) {
            if (invStack.method_7960()) {
                return true;
            }
            if (!class_1799.method_31577((class_1799)invStack, (class_1799)stack) || (count -= invStack.method_7914() - invStack.method_7947()) > 0) continue;
            return true;
        }
        return false;
    }

    public class_1799 insert(class_1799 stack) {
        class_1799 invStack;
        int currentSlot;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        int invSize = this.method_11282().size();
        for (currentSlot = 0; currentSlot < invSize; ++currentSlot) {
            invStack = (class_1799)this.method_11282().get(currentSlot);
            if (class_1799.method_31577((class_1799)invStack, (class_1799)stack)) {
                int space = invStack.method_7914() - invStack.method_7947();
                int inserted = Math.min(space, stack.method_7947());
                invStack.method_7933(inserted);
                this.method_5447(currentSlot, invStack);
                stack.method_7934(inserted);
            }
            if (stack.method_7947() > 0) continue;
            return stack;
        }
        if (stack.method_7947() <= 0) {
            return stack;
        }
        for (currentSlot = 0; currentSlot < invSize; ++currentSlot) {
            invStack = (class_1799)this.method_11282().get(currentSlot);
            if (invStack.method_7960()) {
                invStack = stack.method_51164();
                this.method_5447(currentSlot, invStack);
            }
            if (stack.method_7947() > 0) continue;
            return stack;
        }
        return stack;
    }

    public class_1799 take(class_1792 item, int count) {
        if (item == class_1802.field_8162 || count == 0) {
            return class_1799.field_8037;
        }
        int invSize = this.method_11282().size();
        for (int currentSlot = this.selectedSlot; currentSlot < invSize + this.selectedSlot; ++currentSlot) {
            class_1799 invStack = (class_1799)this.method_11282().get(currentSlot % invSize);
            if (invStack.method_7960()) continue;
            if (invStack.method_31574(item)) {
                int available = invStack.method_7947();
                int removed = Math.min(count, available);
                invStack.method_7934(removed);
                this.method_5447(currentSlot % invSize, invStack);
                count -= removed;
            }
            if (count > 0) continue;
            return new class_1799((class_1935)item, count);
        }
        return new class_1799((class_1935)item, count);
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BlockDispenserScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11014(nbt, lookup);
        class_1262.method_5429((class_2487)nbt, (class_2371)this.method_11282(), (class_7225.class_7874)lookup);
        this.selectedSlot = nbt.method_10550("nextSlotToDispense");
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        class_1262.method_5426((class_2487)nbt, (class_2371)this.method_11282(), (class_7225.class_7874)lookup);
        nbt.method_10569("nextSlotToDispense", this.selectedSlot);
    }

    public int[] method_5494(class_2350 side) {
        return AVAILABLE_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return true;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }
}

