/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks.detector;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.SimpleFacingBlock;
import com.bwt.blocks.detector.DetectorLogicBlock;
import com.bwt.blocks.lens.LensBlock;
import com.bwt.sounds.BwtSoundEvents;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class DetectorBlock
extends SimpleFacingBlock {
    public static final class_2746 POWERED = class_2741.field_12484;
    private static final int tickRate = 4;

    public DetectorBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{POWERED});
    }

    @Override
    @NotNull
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)super.method_9605(ctx).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        world.method_39279(pos, (class_2248)this, 4);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        boolean detected = this.checkForDetection(world, pos, state);
        boolean wasDetected = (Boolean)state.method_11654((class_2769)POWERED);
        if (detected != wasDetected) {
            world.method_39279(pos, (class_2248)this, 4);
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9588(state, world, pos, random);
        boolean placedLogic = this.placeDetectorLogicIfNecessary((class_1937)world, pos, state);
        boolean detected = this.checkForDetection((class_1937)world, pos, state);
        boolean wasDetected = (Boolean)state.method_11654((class_2769)POWERED);
        if (((class_2350)state.method_11654((class_2769)field_10927)).equals((Object)class_2350.field_11036)) {
            detected |= world.method_8311(pos.method_10084()) && world.method_8520(pos.method_10084());
            world.method_39279(pos, (class_2248)this, 4);
        }
        if (detected) {
            if (!wasDetected) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                world.method_8396(null, pos, BwtSoundEvents.DETECTOR_CLICK, class_3419.field_15245, 1.0f, 2.0f);
            }
        } else if (wasDetected) {
            if (!placedLogic) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                world.method_8396(null, pos, BwtSoundEvents.DETECTOR_CLICK, class_3419.field_15245, 1.0f, 2.0f);
            } else {
                world.method_39279(pos, (class_2248)this, 4);
            }
        }
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return (Boolean)state.method_11654((class_2769)POWERED) != false ? 15 : 0;
    }

    public boolean placeDetectorLogicIfNecessary(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_10927);
        class_2338 targetPos = pos.method_10093(facing);
        class_2680 targetState = world.method_8320(targetPos);
        if (targetState.method_26164(class_3481.field_51989) && !targetState.method_27852(BwtBlocks.detectorLogicBlock) && !targetState.method_27852((class_2248)BwtBlocks.lensBeamBlock)) {
            world.method_30092(targetPos, BwtBlocks.detectorLogicBlock.method_9564(), 3, 0);
            return true;
        }
        return false;
    }

    public void removeDetectorLogicIfNecessary(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_10927);
        class_2338 targetPos = pos.method_10093(facing);
        class_2680 targetState = world.method_8320(targetPos);
        if (targetState.method_27852(BwtBlocks.detectorLogicBlock) && !DetectorLogicBlock.anyNeighborDetectors((class_1936)world, pos)) {
            world.method_30092(targetPos, class_2246.field_10124.method_9564(), 3, 0);
        }
    }

    public boolean checkForDetection(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_10927);
        class_2338 targetPos = pos.method_10093(facing);
        class_2680 targetState = world.method_8320(targetPos);
        if (targetState.method_26164(class_3481.field_51989) && !targetState.method_27852(BwtBlocks.detectorLogicBlock) && !targetState.method_27852((class_2248)BwtBlocks.lensBeamBlock)) {
            return false;
        }
        if (targetState.method_27852((class_2248)BwtBlocks.lensBlock) && ((class_2350)targetState.method_11654((class_2769)LensBlock.field_10927)).equals((Object)facing.method_10153())) {
            return (Boolean)targetState.method_11654((class_2769)LensBlock.LIT);
        }
        if (!targetState.method_27852(BwtBlocks.detectorLogicBlock)) {
            return true;
        }
        if (((class_2350)state.method_11654((class_2769)field_10927)).equals((Object)class_2350.field_11036) && world.method_8311(pos.method_10084()) && world.method_8520(pos.method_10084())) {
            return true;
        }
        return DetectorLogicBlock.isEnabled(targetState);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (!((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            return;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_10927);
        class_2338 blockPos = pos.method_10093(facing);
        if (world.method_8320(blockPos).method_26216((class_1922)world, blockPos)) {
            return;
        }
        class_2350.class_2351 axis = facing.method_10166();
        double e = axis == class_2350.class_2351.field_11048 ? 0.5 + 0.5625 * (double)facing.method_10148() : (double)random.method_43057();
        double f = axis == class_2350.class_2351.field_11052 ? 0.5 + 0.5625 * (double)facing.method_10164() : (double)random.method_43057();
        double g = axis == class_2350.class_2351.field_11051 ? 0.5 + 0.5625 * (double)facing.method_10165() : (double)random.method_43057();
        world.method_8406((class_2394)class_2390.field_11188, (double)pos.method_10263() + e, (double)pos.method_10264() + f, (double)pos.method_10260() + g, 0.0, 0.0, 0.0);
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (!newState.method_27852((class_2248)this)) {
            this.removeDetectorLogicIfNecessary(world, pos, state);
        }
    }
}

