/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks.lens;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.detector.DetectorBlock;
import com.bwt.blocks.lens.LensBeamBlock;
import com.bwt.blocks.lens.LensBlock;
import com.bwt.gamerules.BwtGameRules;
import com.bwt.utils.BlockPosAndState;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_5575;
import net.minecraft.class_7165;

public class LensBeamHelper {
    protected static boolean anyEntitiesIntersecting(class_1937 world, class_2338 pos) {
        ArrayList list = Lists.newArrayList();
        world.method_47575(class_5575.method_31795(class_1297.class), new class_238(pos), class_1301.field_6155, (List)list, 1);
        return !list.isEmpty();
    }

    protected static int getRemainingRange(class_1937 world, class_2338 pos, class_2350 direction) {
        int distanceFromLens;
        class_2338.class_2339 mutable = pos.method_25503();
        int maxRange = world.method_8450().method_8356(BwtGameRules.LENS_BEAM_RANGE);
        for (distanceFromLens = 0; distanceFromLens < maxRange; ++distanceFromLens) {
            mutable.method_10098(direction.method_10153());
            class_2680 possibleLensBlockState = world.method_8320((class_2338)mutable);
            if (!possibleLensBlockState.method_27852((class_2248)BwtBlocks.lensBeamBlock)) continue;
            if (!((Boolean)possibleLensBlockState.method_11654((class_2769)LensBeamBlock.FACING_PROPERTIES.get(direction))).booleanValue()) break;
        }
        return maxRange - distanceFromLens;
    }

    public static void fireBeam(class_1937 world, class_2338 lensPos, class_2680 lensState) {
        LensBeamHelper.propagateBeam(world, lensPos, lensState, (class_2350)lensState.method_11654((class_2769)LensBlock.field_10927), world.method_8450().method_8356(BwtGameRules.LENS_BEAM_RANGE));
    }

    public static void killBeam(class_1937 world, class_2338 originPos, class_2350 facing) {
        class_2680 targetState;
        class_2338 targetPos = originPos;
        while ((targetState = world.method_8320(targetPos = targetPos.method_10093(facing))).method_26204() instanceof LensBeamBlock && ((Boolean)targetState.method_11654((class_2769)LensBeamBlock.FACING_PROPERTIES.get(facing))).booleanValue()) {
            LensBeamHelper.removeBeam(world, targetPos, targetState, facing);
        }
    }

    public static void propagateBeam(class_1937 world, class_2338 originBeamPos, class_2680 originBeamState, class_2350 facing, int range) {
        boolean targetBlockIsForwardFacingBeam;
        LensBeamBlock beamBlock;
        if (range <= 0) {
            return;
        }
        if (!(originBeamState.method_26204() instanceof LensBeamBlock) && !originBeamState.method_27852((class_2248)BwtBlocks.lensBlock)) {
            return;
        }
        class_2338 targetPos = originBeamPos.method_10093(facing);
        class_2680 targetState = world.method_8320(targetPos);
        class_2248 targetBlock = targetState.method_26204();
        LensBeamBlock lensBeamBlock = targetBlock instanceof LensBeamBlock ? (beamBlock = (LensBeamBlock)targetBlock) : null;
        boolean targetBlockIsBeamPermeable = targetState.method_26164(class_3481.field_51989) || targetState.method_27852((class_2248)BwtBlocks.lensBeamGlassBlock) || targetState.method_27852(BwtBlocks.lensBeamGlassBlock.glassBlock);
        boolean bl = targetBlockIsForwardFacingBeam = lensBeamBlock != null && (Boolean)targetState.method_11654((class_2769)LensBeamBlock.FACING_PROPERTIES.get(facing)) != false;
        if (!targetBlockIsBeamPermeable || targetBlockIsForwardFacingBeam) {
            if (!targetBlockIsBeamPermeable && originBeamState.method_26204() instanceof LensBeamBlock) {
                LensBeamHelper.setTerminus(world, originBeamPos, originBeamState, true);
            }
            return;
        }
        boolean entitiesIntersecting = LensBeamHelper.anyEntitiesIntersecting(world, targetPos);
        targetState = LensBeamHelper.addBeam(world, targetPos, targetState, facing, entitiesIntersecting);
        if (entitiesIntersecting) {
            return;
        }
        LensBeamHelper.propagateBeam(world, targetPos, targetState, facing, range - 1);
    }

    public static class_2680 addBeam(class_1937 world, class_2338 targetPos, class_2680 targetState, class_2350 facingToAdd, boolean entitiesIntersecting) {
        class_2680 newState = targetState;
        if (!(newState.method_26204() instanceof LensBeamBlock)) {
            if (newState.method_26164(class_3481.field_51989)) {
                newState = BwtBlocks.lensBeamBlock.method_9564();
            } else if (newState.method_27852(BwtBlocks.lensBeamGlassBlock.glassBlock)) {
                newState = BwtBlocks.lensBeamGlassBlock.method_9564();
            }
        }
        newState = (class_2680)((class_2680)newState.method_11657((class_2769)LensBeamBlock.FACING_PROPERTIES.get(facingToAdd), (Comparable)Boolean.valueOf(true))).method_11657((class_2769)LensBeamBlock.TERMINUS, (Comparable)Boolean.valueOf(entitiesIntersecting || (Boolean)newState.method_11654((class_2769)LensBeamBlock.TERMINUS) != false));
        world.method_8652(targetPos, newState, 18);
        return newState;
    }

    public static void removeBeam(class_1937 world, class_2338 targetPos, class_2680 targetState, class_2350 facingToRemove) {
        boolean terminusModified;
        class_2680 newState = (class_2680)targetState.method_11657((class_2769)LensBeamBlock.FACING_PROPERTIES.get(facingToRemove), (Comparable)Boolean.valueOf(false));
        boolean replacedWithAir = false;
        if (LensBeamHelper.streamFacingDirections(newState).findAny().isEmpty()) {
            class_2680 class_26802;
            class_2248 class_22482 = newState.method_26204();
            if (class_22482 instanceof LensBeamBlock) {
                LensBeamBlock beamBlock = (LensBeamBlock)class_22482;
                class_26802 = beamBlock.getStateLeftOverWhenEmpty((class_1936)world, targetPos);
            } else {
                class_26802 = class_2246.field_10124.method_9564();
            }
            newState = class_26802;
            terminusModified = (Boolean)targetState.method_11654((class_2769)LensBeamBlock.TERMINUS);
            replacedWithAir = newState.method_26164(class_3481.field_51989);
        } else {
            newState = (class_2680)newState.method_11657((class_2769)LensBeamBlock.TERMINUS, (Comparable)Boolean.valueOf(LensBeamHelper.anyNeighborNotPropagable((class_1936)world, targetPos, newState)));
            terminusModified = targetState.method_11654((class_2769)LensBeamBlock.TERMINUS) != newState.method_11654((class_2769)LensBeamBlock.TERMINUS);
        }
        world.method_8652(targetPos, newState, 2 | (terminusModified ? 0 : 16));
        if (replacedWithAir || terminusModified) {
            for (class_2350 direction : class_7165.field_37839) {
                boolean detectorFacingIntoBeam;
                BlockPosAndState neighborPosAndState = BlockPosAndState.of((class_1936)world, targetPos.method_10093(direction));
                boolean facingIntoNeighbor = (Boolean)targetState.method_11654((class_2769)LensBeamBlock.FACING_PROPERTIES.get(direction)) != false && !neighborPosAndState.state().method_26164(class_3481.field_51989);
                boolean bl = detectorFacingIntoBeam = neighborPosAndState.state().method_27852(BwtBlocks.detectorBlock) && ((class_2350)neighborPosAndState.state().method_11654((class_2769)DetectorBlock.field_10927)).equals((Object)direction.method_10153());
                if (detectorFacingIntoBeam || facingIntoNeighbor && terminusModified) {
                    world.method_41410(neighborPosAndState.state(), neighborPosAndState.pos(), newState.method_26204(), targetPos, false);
                }
                if (!facingIntoNeighbor || !terminusModified) continue;
                world.method_42308(direction.method_10153(), newState, neighborPosAndState.pos(), targetPos, 2, 512);
            }
        }
    }

    public static boolean anyNeighborNotPropagable(class_1936 world, class_2338 pos, class_2680 state) {
        return LensBeamHelper.streamFacingDirections(state).map(Map.Entry::getKey).map(arg_0 -> ((class_2338)pos).method_10093(arg_0)).map(arg_0 -> ((class_1936)world).method_8320(arg_0)).anyMatch(blockState -> !blockState.method_26164(class_3481.field_51989) && !blockState.method_27852((class_2248)BwtBlocks.lensBeamGlassBlock) && !blockState.method_27852(BwtBlocks.lensBeamGlassBlock.glassBlock));
    }

    public static class_2680 setTerminus(class_1937 world, class_2338 pos, class_2680 state, boolean terminus) {
        if ((Boolean)state.method_11654((class_2769)LensBeamBlock.TERMINUS) != terminus) {
            state = (class_2680)state.method_11657((class_2769)LensBeamBlock.TERMINUS, (Comparable)Boolean.valueOf(terminus));
            world.method_8652(pos, state, 3);
        }
        return state;
    }

    public static boolean isValidInputBeamOrLens(class_2680 neighborState, class_2350 directionToThisBlock) {
        return neighborState.method_27852((class_2248)BwtBlocks.lensBlock) && ((class_2350)neighborState.method_11654((class_2769)LensBlock.field_10927)).equals((Object)directionToThisBlock) && (Boolean)neighborState.method_11654((class_2769)LensBlock.LIT) != false || neighborState.method_26204() instanceof LensBeamBlock && (Boolean)neighborState.method_11654((class_2769)LensBeamBlock.FACING_PROPERTIES.get(directionToThisBlock)) != false;
    }

    public static Stream<Map.Entry<class_2350, class_2746>> streamFacingDirections(class_2680 state) {
        return LensBeamBlock.FACING_PROPERTIES.entrySet().stream().filter(entry -> (Boolean)state.method_11654((class_2769)entry.getValue()));
    }
}

