/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks.mining_charge;

import com.bwt.blocks.SidingBlock;
import com.bwt.blocks.mining_charge.ICaughtFireBlock;
import com.bwt.entities.MiningChargeEntity;
import com.bwt.sounds.BwtSoundEvents;
import com.bwt.utils.BlockUtils;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class MiningChargeBlock
extends class_2341
implements ICaughtFireBlock {
    protected static final class_238 BOTTOM_SHAPE = new class_238(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    protected static final List<class_265> COLLISION_SHAPES = Arrays.stream(class_2350.values()).map(direction -> BlockUtils.rotateCuboidFromUp(direction, BOTTOM_SHAPE)).toList();
    public static final MapCodec<MiningChargeBlock> CODEC = SidingBlock.method_54094(MiningChargeBlock::new);

    public MiningChargeBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)field_11007, (Comparable)class_2738.field_12471));
        FlammableBlockRegistry.getDefaultInstance().add((class_2248)this, 15, 100);
    }

    public MapCodec<? extends MiningChargeBlock> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{field_11177, field_11007});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return COLLISION_SHAPES.get(MiningChargeBlock.getSurfaceOrientation(state).method_10146());
    }

    public class_2680 getDispenserPlacmentState(class_1750 ctx) {
        int n = 0;
        class_2350[] class_2350Array = ctx.method_7718();
        int n2 = class_2350Array.length;
        if (n < n2) {
            class_2350 direction = class_2350Array[n];
            class_2680 blockState = direction.method_10166() == class_2350.class_2351.field_11052 ? (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11007, (Comparable)(direction == class_2350.field_11036 ? class_2738.field_12473 : class_2738.field_12475))).method_11657((class_2769)field_11177, (Comparable)ctx.method_8042()) : (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11007, (Comparable)class_2738.field_12471)).method_11657((class_2769)field_11177, (Comparable)direction.method_10153());
            return blockState;
        }
        return null;
    }

    public static boolean isHorizontal(class_2680 state) {
        return state.method_11654((class_2769)field_11007) == class_2738.field_12471;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (world.method_49803(pos)) {
            world.method_39279(pos, (class_2248)this, 1);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return state;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.method_49803(pos)) {
            world.method_39279(pos, (class_2248)this, 1);
        }
        if (world.field_9236 || !world.method_8320(pos).method_27852((class_2248)this)) {
            return;
        }
        if (this.method_9558(state, (class_4538)world, pos)) {
            return;
        }
        MiningChargeBlock.method_9497((class_2680)state, (class_1937)world, (class_2338)pos);
        world.method_8650(pos, notify);
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (moved) {
            return;
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        MiningChargeBlock.prime((class_1937)world, pos, state, null);
        world.method_8650(pos, false);
    }

    @Deprecated
    public void method_55124(class_2680 state, class_1937 world, class_2338 pos, class_1927 explosion, BiConsumer<class_1799, class_2338> stackMerger) {
        if (state.method_26164(class_3481.field_51989) || explosion.method_55111() == class_1927.class_4179.field_47331) {
            return;
        }
        world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        if (world.field_9236) {
            return;
        }
        MiningChargeEntity miningChargeEntity = new MiningChargeEntity(world, pos.method_46558().method_1023(0.0, 0.5, 0.0), state, explosion.method_8347());
        miningChargeEntity.setFuse(1);
        world.method_8649((class_1297)miningChargeEntity);
    }

    private static void prime(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 igniter) {
        if (world.field_9236) {
            return;
        }
        MiningChargeEntity miningChargeEntity = new MiningChargeEntity(world, pos.method_46558().method_1023(0.0, 0.5, 0.0), state, igniter);
        world.method_8649((class_1297)miningChargeEntity);
        world.method_43128(null, miningChargeEntity.method_23317(), miningChargeEntity.method_23318(), miningChargeEntity.method_23321(), BwtSoundEvents.MINING_CHARGE_PRIME, class_3419.field_15245, 1.0f, 1.0f);
        world.method_33596((class_1297)igniter, (class_6880)class_5712.field_28727, pos);
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1799 itemStack = player.method_5998(player.method_6058());
        if (!itemStack.method_31574(class_1802.field_8884) && !itemStack.method_31574(class_1802.field_8814)) {
            return super.method_55766(state, world, pos, player, hit);
        }
        MiningChargeBlock.prime(world, pos, state, (class_1309)player);
        world.method_8652(pos, class_2246.field_10124.method_9564(), 11);
        class_1792 item = itemStack.method_7909();
        if (!player.method_7337()) {
            if (itemStack.method_31574(class_1802.field_8884)) {
                itemStack.method_7970(1, (class_1309)player, class_1657.method_56079((class_1268)player.method_6058()));
            } else {
                itemStack.method_7934(1);
            }
        }
        player.method_7259(class_3468.field_15372.method_14956((Object)item));
        return class_1269.method_29236((boolean)world.field_9236);
    }

    public void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        if (!world.field_9236) {
            class_2338 blockPos = hit.method_17777();
            class_1297 entity = projectile.method_24921();
            if (projectile.method_5809() && projectile.method_36971(world, blockPos)) {
                MiningChargeBlock.prime(world, blockPos, state, entity instanceof class_1309 ? (class_1309)entity : null);
                world.method_8650(blockPos, false);
            }
        }
    }

    public boolean method_9533(class_1927 explosion) {
        return false;
    }

    public static class_2350 getSurfaceOrientation(class_2680 state) {
        return switch ((class_2738)state.method_11654((class_2769)field_11007)) {
            default -> throw new MatchException(null, null);
            case class_2738.field_12471 -> (class_2350)state.method_11654((class_2769)field_11177);
            case class_2738.field_12475 -> class_2350.field_11036;
            case class_2738.field_12473 -> class_2350.field_11033;
        };
    }

    public static class_2680 withSurfaceOrientation(class_2680 state, class_2350 direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036 -> (class_2680)state.method_11657((class_2769)field_11007, (Comparable)class_2738.field_12475);
            case class_2350.field_11033 -> (class_2680)state.method_11657((class_2769)field_11007, (Comparable)class_2738.field_12473);
            case class_2350.field_11043 -> (class_2680)((class_2680)state.method_11657((class_2769)field_11007, (Comparable)class_2738.field_12471)).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11035);
            case class_2350.field_11034 -> (class_2680)((class_2680)state.method_11657((class_2769)field_11007, (Comparable)class_2738.field_12471)).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11039);
            case class_2350.field_11035 -> (class_2680)((class_2680)state.method_11657((class_2769)field_11007, (Comparable)class_2738.field_12471)).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043);
            case class_2350.field_11039 -> (class_2680)((class_2680)state.method_11657((class_2769)field_11007, (Comparable)class_2738.field_12471)).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11034);
        };
    }

    @Override
    public boolean onCaughtFire(class_2680 state, class_1937 world, class_2338 pos, @Nullable class_2350 direction, @Nullable class_1309 igniter) {
        MiningChargeBlock.prime(world, pos, state, igniter);
        return true;
    }
}

