/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks.turntable;

import com.bwt.blocks.AnchorBlock;
import com.bwt.blocks.HandCrankBlock;
import com.bwt.blocks.MouldingBlock;
import com.bwt.blocks.SawBlock;
import com.bwt.blocks.SidingBlock;
import com.bwt.blocks.mining_charge.MiningChargeBlock;
import com.bwt.tags.BwtBlockTags;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public interface VerticalBlockAttachmentHelper {
    public static final HashMap<Class<? extends class_2248>, CanPropagatePredicate> canPropagatePredicates = new HashMap();

    public static void register(Class<? extends class_2248> blockClass, CanPropagatePredicate canPropagatePredicate) {
        canPropagatePredicates.put(blockClass, canPropagatePredicate);
    }

    public static boolean canPropagateRotationUpwards(class_1937 world, class_2338 pos, class_2680 state) {
        class_2248 block = state.method_26204();
        return canPropagatePredicates.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isInstance(block)).findAny().map(Map.Entry::getValue).orElse(CanPropagatePredicate.DEFAULT).test(world, pos, state);
    }

    public static void registerDefaults() {
        VerticalBlockAttachmentHelper.register(class_2189.class, CanPropagatePredicate.FALSE);
        VerticalBlockAttachmentHelper.register(SidingBlock.class, (world, pos, state) -> SidingBlock.isHorizontal(state));
        VerticalBlockAttachmentHelper.register(MouldingBlock.class, (world, pos, state) -> MouldingBlock.isVertical(state));
        VerticalBlockAttachmentHelper.register(AnchorBlock.class, (world, pos, state) -> AnchorBlock.isHorizontal(state));
        VerticalBlockAttachmentHelper.register(SawBlock.class, (world, pos, state) -> SawBlock.isHorizontal(state));
        VerticalBlockAttachmentHelper.register(MiningChargeBlock.class, (world, pos, state) -> MiningChargeBlock.isHorizontal(state));
        VerticalBlockAttachmentHelper.register(HandCrankBlock.class, CanPropagatePredicate.FALSE);
    }

    public static interface CanPropagatePredicate {
        public static final CanPropagatePredicate FALSE = (world, pos, state) -> false;
        public static final CanPropagatePredicate TRUE = (world, pos, state) -> true;
        public static final CanPropagatePredicate DEFAULT = (world, pos, state) -> state.method_26234((class_1922)world, pos) || state.method_26164(BwtBlockTags.TRANSFERS_ROTATION_UPWARD_OVERRIDE);

        public boolean test(class_1937 var1, class_2338 var2, class_2680 var3);
    }
}

