/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.emi.recipehandlers;

import com.bwt.blocks.soul_forge.SoulForgeScreenHandler;
import com.bwt.emi.BwtEmiPlugin;
import com.bwt.emi.recipes.EmiSoulForgeRecipe;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1735;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EmiSoulForgeRecipeHandler {
    public static List<EmiRecipeCategory> CATEGORIES = List.of(BwtEmiPlugin.SOUL_FORGE, VanillaEmiRecipeCategories.CRAFTING);

    @Environment(value=EnvType.CLIENT)
    public static class ThreeByThree
    implements StandardRecipeHandler<SoulForgeScreenHandler> {
        @Nullable
        public class_1735 getOutputSlot(SoulForgeScreenHandler handler) {
            return (class_1735)handler.field_7761.get(0);
        }

        public List<class_1735> getInputSources(SoulForgeScreenHandler handler) {
            ArrayList<class_1735> slots = new ArrayList<class_1735>();
            slots.addAll(handler.field_7761.subList(1, 4));
            slots.addAll(handler.field_7761.subList(5, 8));
            slots.addAll(handler.field_7761.subList(9, 12));
            slots.addAll(handler.field_7761.subList(17, handler.field_7761.size()));
            return slots;
        }

        public List<class_1735> getCraftingSlots(SoulForgeScreenHandler handler) {
            ArrayList<class_1735> slots = new ArrayList<class_1735>();
            slots.addAll(handler.field_7761.subList(1, 4));
            slots.addAll(handler.field_7761.subList(5, 8));
            slots.addAll(handler.field_7761.subList(9, 12));
            return slots;
        }

        public boolean supportsRecipe(EmiRecipe recipe) {
            if (!CATEGORIES.contains(recipe.getCategory())) {
                return false;
            }
            if (recipe instanceof EmiSoulForgeRecipe) {
                EmiSoulForgeRecipe soulForgeRecipe = (EmiSoulForgeRecipe)recipe;
                return soulForgeRecipe.canFit(3, 3);
            }
            if (recipe instanceof EmiCraftingRecipe) {
                EmiCraftingRecipe craftingRecipe = (EmiCraftingRecipe)recipe;
                return craftingRecipe.canFit(3, 3);
            }
            return recipe.getInputs().size() <= 9;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FourByFour
    implements StandardRecipeHandler<SoulForgeScreenHandler> {
        @Nullable
        public class_1735 getOutputSlot(SoulForgeScreenHandler handler) {
            return (class_1735)handler.field_7761.get(0);
        }

        public List<class_1735> getInputSources(SoulForgeScreenHandler handler) {
            return handler.field_7761.subList(1, handler.field_7761.size());
        }

        public List<class_1735> getCraftingSlots(SoulForgeScreenHandler handler) {
            return handler.field_7761.subList(1, 17);
        }

        public boolean supportsRecipe(EmiRecipe recipe) {
            if (!CATEGORIES.contains(recipe.getCategory())) {
                return false;
            }
            if (recipe instanceof EmiSoulForgeRecipe) {
                EmiSoulForgeRecipe soulForgeRecipe = (EmiSoulForgeRecipe)recipe;
                return soulForgeRecipe.canFit(4, 4) && !soulForgeRecipe.canFit(3, 3);
            }
            if (recipe instanceof EmiCraftingRecipe) {
                EmiCraftingRecipe craftingRecipe = (EmiCraftingRecipe)recipe;
                return craftingRecipe.canFit(4, 4) && !craftingRecipe.canFit(3, 3);
            }
            return recipe.getInputs().size() > 9;
        }
    }
}

