/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.emi.recipes;

import com.bwt.emi.BwtEmiPlugin;
import com.bwt.recipes.cooking_pots.AbstractCookingPotRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EmiCookingPotRecipe<R extends AbstractCookingPotRecipe>
implements EmiRecipe {
    private final EmiRecipeCategory category;
    private final class_2960 id;
    private final List<EmiIngredient> ingredients;
    private final List<EmiStack> results;
    private final int displayRows;

    public EmiCookingPotRecipe(EmiRecipeCategory category, class_8786<R> recipeEntry) {
        this(category, recipeEntry.comp_1932(), (AbstractCookingPotRecipe)recipeEntry.comp_1933());
    }

    public EmiCookingPotRecipe(EmiRecipeCategory category, class_2960 id, R recipe) {
        this.category = category;
        this.id = id;
        this.ingredients = ((AbstractCookingPotRecipe)recipe).getIngredientsWithCount().stream().map(BwtEmiPlugin::from).toList();
        this.results = ((AbstractCookingPotRecipe)recipe).getResults().stream().map(EmiStack::of).toList();
        this.displayRows = IntStream.of((int)Math.ceil((double)this.ingredients.size() / 3.0), (int)Math.ceil((double)this.results.size() / 3.0), 1).max().orElse(1);
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public class_2960 getId() {
        return class_2960.method_60655((String)this.id.method_12836(), (String)("/" + this.id.method_12832()));
    }

    public List<EmiIngredient> getInputs() {
        return this.ingredients;
    }

    public List<EmiStack> getOutputs() {
        return this.results;
    }

    public int getDisplayWidth() {
        return 140;
    }

    public int getDisplayHeight() {
        return this.displayRows * 18;
    }

    public void addWidgets(WidgetHolder widgets) {
        int y = 0;
        int x = 0;
        widgets.addTexture(EmiTexture.EMPTY_FLAME, 60, 0).tooltip(List.of(EmiTooltipComponents.of((class_2561)class_2561.method_43470((String)this.id.toString()))));
        widgets.addAnimatedTexture(EmiTexture.FULL_FLAME, 60, 0, 19500, false, true, false);
        int i = 0;
        int constantInputSlots = 3;
        int constantOutputSlots = 3;
        for (EmiIngredient emiIngredient : this.ingredients) {
            widgets.addSlot(emiIngredient, x + i % 3 * 18, y + i / 3 * 18);
            ++i;
        }
        while (i < constantInputSlots) {
            widgets.addSlot((EmiIngredient)EmiStack.EMPTY, x + i % 3 * 18, y + i / 3 * 18);
            ++i;
        }
        i = 0;
        x = 80;
        for (EmiIngredient emiIngredient : this.results) {
            widgets.addSlot(emiIngredient, x + i * 18, y).recipeContext((EmiRecipe)this);
            ++i;
        }
        while (i < constantOutputSlots) {
            widgets.addSlot((EmiIngredient)EmiStack.EMPTY, x + i % 3 * 18, y + i / 3 * 18).recipeContext((EmiRecipe)this);
            ++i;
        }
    }
}

