/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.emi.recipes;

import com.bwt.blocks.BwtBlocks;
import com.bwt.emi.BwtEmiPlugin;
import com.bwt.recipes.saw.SawRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EmiSawRecipe
implements EmiRecipe {
    private final EmiRecipeCategory category;
    private final class_2960 id;
    private final EmiIngredient ingredient;
    private final List<EmiStack> results;
    private final int displayRows;

    public EmiSawRecipe(EmiRecipeCategory category, class_8786<SawRecipe> recipeEntry) {
        this(category, recipeEntry.comp_1932(), (SawRecipe)recipeEntry.comp_1933());
    }

    public EmiSawRecipe(EmiRecipeCategory category, class_2960 id, SawRecipe recipe) {
        this.category = category;
        this.id = id;
        this.ingredient = BwtEmiPlugin.from(recipe.getIngredient());
        this.results = recipe.getResults().stream().map(EmiStack::of).toList();
        this.displayRows = IntStream.of((int)Math.ceil((double)this.results.size() / 3.0), 1).max().orElse(1);
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public class_2960 getId() {
        return class_2960.method_60655((String)this.id.method_12836(), (String)("/" + this.id.method_12832()));
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.ingredient);
    }

    public List<EmiStack> getOutputs() {
        return this.results;
    }

    public int getDisplayWidth() {
        return 100;
    }

    public int getDisplayHeight() {
        return 20 * this.displayRows;
    }

    public void addWidgets(WidgetHolder widgets) {
        int y = 0;
        int x = 0;
        int i = 0;
        int constantOutputSlots = 3;
        widgets.addSlot(this.ingredient, x, y);
        x = 20;
        widgets.addSlot((EmiIngredient)EmiStack.of((class_1935)BwtBlocks.sawBlock), x, y).drawBack(false);
        x = 40;
        for (EmiIngredient emiIngredient : this.results) {
            widgets.addSlot(emiIngredient, x + i * 18, y).recipeContext((EmiRecipe)this);
            ++i;
        }
        while (i < constantOutputSlots) {
            widgets.addSlot((EmiIngredient)EmiStack.EMPTY, x + i % 3 * 18, y + i / 3 * 18).recipeContext((EmiRecipe)this);
            ++i;
        }
    }
}

