/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.emi.recipes;

import com.bwt.emi.BwtEmiPlugin;
import com.bwt.recipes.soul_forge.SoulForgeRecipe;
import com.bwt.recipes.soul_forge.SoulForgeShapedRecipe;
import com.bwt.utils.Id;
import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EmiSoulForgeRecipe
implements EmiRecipe {
    private final EmiRecipeCategory category;
    protected final class_2960 id;
    protected final List<EmiIngredient> input;
    protected final EmiStack output;
    private final int size;
    private final SoulForgeRecipe recipe;

    public EmiSoulForgeRecipe(class_8786<SoulForgeRecipe> recipeEntry) {
        this((SoulForgeRecipe)recipeEntry.comp_1933(), recipeEntry.comp_1932());
    }

    public EmiSoulForgeRecipe(SoulForgeRecipe recipe, class_2960 id) {
        this.id = Id.of(String.format("%s-%s-%s", "soulforge", id.method_12836(), id.method_12832()));
        if (recipe instanceof SoulForgeShapedRecipe) {
            SoulForgeShapedRecipe shapedRecipe = (SoulForgeShapedRecipe)recipe;
            this.input = EmiSoulForgeRecipe.padIngredients(shapedRecipe);
        } else {
            this.input = recipe.method_8117().stream().map(EmiIngredient::of).toList();
        }
        this.output = EmiStack.of((class_1799)recipe.method_8110(null));
        this.recipe = recipe;
        this.size = 4;
        this.category = BwtEmiPlugin.SOUL_FORGE;
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public class_2960 getId() {
        return class_2960.method_60655((String)this.id.method_12836(), (String)("/" + this.id.method_12832()));
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getDisplayWidth() {
        return 118 + (this.size == 4 ? 20 : 0);
    }

    public int getDisplayHeight() {
        return 18 * this.size;
    }

    public boolean canFit(int width, int height) {
        if (this.input.size() > this.size * this.size) {
            return false;
        }
        for (int i = 0; i < this.input.size(); ++i) {
            int x = i % this.size;
            int y = i / this.size;
            if (this.input.get(i).isEmpty() || x < width && y < height) continue;
            return false;
        }
        return true;
    }

    public void addWidgets(WidgetHolder widgets) {
        SoulForgeRecipe soulForgeRecipe;
        int sizeXOffset = this.size == 4 ? 18 : 0;
        int sizeYOffset = this.size == 4 ? 10 : 0;
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 60 + sizeXOffset, 18 + sizeYOffset);
        if (this.recipe instanceof class_1867) {
            widgets.addTexture(EmiTexture.SHAPELESS, 97 + sizeXOffset, sizeYOffset);
        }
        if ((soulForgeRecipe = this.recipe) instanceof SoulForgeShapedRecipe) {
            SoulForgeShapedRecipe shapedRecipe = (SoulForgeShapedRecipe)soulForgeRecipe;
            this.addShapedWidgets(widgets, shapedRecipe);
        } else {
            this.addShapelessWidgets(widgets);
        }
        widgets.addSlot((EmiIngredient)this.output, 92 + sizeXOffset, 14 + sizeYOffset).large(true).recipeContext((EmiRecipe)this);
    }

    private void addShapedWidgets(WidgetHolder widgets, SoulForgeShapedRecipe shapedRecipe) {
        int i = 0;
        for (int y = 0; y < this.size; ++y) {
            for (int x = 0; x < this.size; ++x) {
                widgets.addSlot(this.input.get(i), i % this.size * 18, i / this.size * 18);
                ++i;
            }
        }
    }

    private void addShapelessWidgets(WidgetHolder widgets) {
        for (int i = 0; i < this.size * this.size; ++i) {
            if (i < this.input.size()) {
                widgets.addSlot(this.input.get(i), i % this.size * 18, i / this.size * 18);
                continue;
            }
            widgets.addSlot((EmiIngredient)EmiStack.of((class_1799)class_1799.field_8037), i % this.size * 18, i / this.size * 18);
        }
    }

    private static List<EmiIngredient> padIngredients(SoulForgeShapedRecipe recipe) {
        ArrayList list = Lists.newArrayList();
        int i = 0;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                if (x >= recipe.method_8150() || y >= recipe.method_8158() || i >= recipe.method_8117().size()) {
                    list.add(EmiStack.EMPTY);
                    continue;
                }
                list.add(EmiIngredient.of((class_1856)((class_1856)recipe.method_8117().get(i++))));
            }
        }
        return list;
    }
}

