/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.entities;

import com.bwt.blocks.AxleBlock;
import com.bwt.blocks.BwtBlocks;
import com.bwt.utils.rectangular_entity.RectangularEntity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_3619;
import net.minecraft.class_5575;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public abstract class HorizontalMechPowerSourceEntity
extends RectangularEntity {
    protected float rotation = 0.0f;
    protected float prevRotation = 0.0f;
    protected int ticksBeforeNextFullUpdate = 20;
    protected static final class_2940<Float> rotationSpeed = class_2945.method_12791(HorizontalMechPowerSourceEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Integer> DAMAGE_WOBBLE_TICKS = class_2945.method_12791(HorizontalMechPowerSourceEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> DAMAGE_WOBBLE_SIDE = class_2945.method_12791(HorizontalMechPowerSourceEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Float> DAMAGE_WOBBLE_STRENGTH = class_2945.method_12791(HorizontalMechPowerSourceEntity.class, (class_2941)class_2943.field_13320);

    public HorizontalMechPowerSourceEntity(class_1299<? extends HorizontalMechPowerSourceEntity> type, class_1937 world) {
        super(type, world);
        this.field_23807 = true;
    }

    public HorizontalMechPowerSourceEntity(class_1299<? extends HorizontalMechPowerSourceEntity> type, class_1937 world, class_243 pos, class_2350 facing) {
        this(type, world);
        this.method_33574(pos);
        this.method_36456(facing.method_10144());
    }

    public abstract boolean tryToSpawn(class_1657 var1);

    public abstract Predicate<class_2338> getBlockInterferencePredicate();

    abstract float computeRotation();

    abstract float getSpeedToPowerThreshold();

    public double method_23320() {
        return this.method_17682() / 2.0f;
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(rotationSpeed, (Object)Float.valueOf(0.0f));
        builder.method_56912(DAMAGE_WOBBLE_TICKS, (Object)0);
        builder.method_56912(DAMAGE_WOBBLE_SIDE, (Object)1);
        builder.method_56912(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(0.0f));
    }

    public float getRotation() {
        return this.rotation;
    }

    protected void setRotation(float rotation) {
        rotation = (rotation + 360.0f) % 360.0f;
        this.prevRotation = this.rotation;
        this.rotation = rotation;
    }

    public float getPrevRotation() {
        return this.prevRotation;
    }

    public float getRotationSpeed() {
        return ((Float)this.method_5841().method_12789(rotationSpeed)).floatValue();
    }

    public void setRotationSpeed(float speed) {
        this.method_5841().method_12778(rotationSpeed, (Object)Float.valueOf(speed));
    }

    public void setDamageWobbleTicks(int damageWobbleTicks) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_TICKS, (Object)damageWobbleTicks);
    }

    public void setDamageWobbleSide(int damageWobbleSide) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_SIDE, (Object)damageWobbleSide);
    }

    public void setDamageWobbleStrength(float damageWobbleStrength) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(damageWobbleStrength));
    }

    public float getDamageWobbleStrength() {
        return ((Float)this.field_6011.method_12789(DAMAGE_WOBBLE_STRENGTH)).floatValue();
    }

    public int getDamageWobbleTicks() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_TICKS);
    }

    public int getDamageWobbleSide() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_SIDE);
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5675() {
        return false;
    }

    public class_3619 method_5657() {
        return class_3619.field_15971;
    }

    public boolean tryToSpawn(class_1657 player, class_2561 blockBlockedErrorMessage, class_2561 entityBlockedErrorMessage) {
        if (player instanceof class_3222) {
            player = null;
        }
        if (this.placementBlockedByBlock()) {
            if (player != null) {
                player.method_43496(blockBlockedErrorMessage);
            }
            return false;
        }
        if (this.placementBlockedByEntity()) {
            if (player != null) {
                player.method_43496(entityBlockedErrorMessage);
            }
            return false;
        }
        if (this.placementHasBadAxleState()) {
            return false;
        }
        this.setRotationSpeed(this.computeRotation());
        class_1937 world = this.method_37908();
        world.method_8649((class_1297)this);
        return true;
    }

    public boolean placementBlockedByBlock() {
        Predicate<class_2338> blockInterferencePredicate = this.getBlockInterferencePredicate();
        return class_2338.method_29715((class_238)this.method_5829()).filter(blockPos -> !blockPos.equals((Object)this.method_24515())).anyMatch(blockInterferencePredicate);
    }

    protected void method_5622(class_2680 state) {
        this.destroyWithDrop();
    }

    public boolean placementBlockedByEntity() {
        ArrayList anyEntities = new ArrayList();
        this.method_37908().method_47575(class_5575.method_31795(class_1297.class), this.method_5829(), entity -> entity != this && class_1301.field_6155.test(entity) && !(entity instanceof class_1542), anyEntities, 1);
        return !anyEntities.isEmpty();
    }

    public boolean placementHasBadAxleState() {
        class_1937 world = this.method_37908();
        class_2680 axleBlock = world.method_8320(this.method_24515());
        if (!axleBlock.method_27852(BwtBlocks.axleBlock) && !axleBlock.method_27852(BwtBlocks.axlePowerSourceBlock)) {
            return true;
        }
        class_2350.class_2351 axleAxis = (class_2350.class_2351)axleBlock.method_11654((class_2769)AxleBlock.field_11459);
        float yaw = this.method_36454();
        return class_2350.method_10169((class_2350.class_2351)axleAxis, (class_2350.class_2352)class_2350.class_2352.field_11060).method_10144() != yaw && class_2350.method_10169((class_2350.class_2351)axleAxis, (class_2350.class_2352)class_2350.class_2352.field_11056).method_10144() != yaw;
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_31481()) {
            return;
        }
        if (this.getDamageWobbleTicks() > 0) {
            this.setDamageWobbleTicks(this.getDamageWobbleTicks() - 1);
        }
        if (this.getDamageWobbleStrength() > 0.0f) {
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() - 1.0f);
        }
        if (this.method_37908().field_9236) {
            this.updateRotation();
        } else {
            --this.ticksBeforeNextFullUpdate;
            if (this.ticksBeforeNextFullUpdate <= 0) {
                this.ticksBeforeNextFullUpdate = 20;
                this.fullUpdate();
            }
        }
        this.method_37908().method_8333((class_1297)this, this.method_5829().method_1009((double)0.01f, (double)0.01f, (double)0.01f), class_1301.method_5911((class_1297)this)).forEach(this::method_5697);
    }

    public void method_5697(class_1297 entity) {
        if (entity.field_5960 || this.field_5960) {
            return;
        }
        class_238 thisBox = this.method_5829().method_1009((double)0.01f, (double)0.01f, (double)0.01f);
        class_238 entityBox = entity.method_5829();
        ArrayList<class_3545> intersections = new ArrayList<class_3545>();
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            class_2350 intersectDirection;
            double thisMin = thisBox.method_1001(axis);
            double thisMax = thisBox.method_990(axis);
            double entityMin = entityBox.method_1001(axis);
            double entityMax = entityBox.method_990(axis);
            if (thisMax - entityMin > 0.0) {
                intersectDirection = class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056);
                intersections.add(new class_3545((Object)intersectDirection, (Object)(thisMax - entityMin)));
            }
            if (!(entityMax - thisMin > 0.0)) continue;
            intersectDirection = class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11060);
            intersections.add(new class_3545((Object)intersectDirection, (Object)(entityMax - thisMin)));
        }
        intersections.stream().min(Comparator.comparingDouble(pair -> Math.abs((Double)pair.method_15441()))).filter(pair -> (Double)pair.method_15441() > (double)0.01f).ifPresent(pair -> entity.method_60491(new class_243(((class_2350)pair.method_15442()).method_23955().mul(((Double)pair.method_15441()).floatValue() / 2.0f))));
    }

    protected void updateRotation() {
        this.setRotation(this.rotation + ((Float)this.method_5841().method_12789(rotationSpeed)).floatValue());
    }

    protected void fullUpdate() {
        if (this.placementBlockedByBlock() || this.placementHasBadAxleState()) {
            this.destroyWithDrop();
            return;
        }
        this.setRotationSpeed(this.computeRotation());
        this.setHostAxlePower(Math.abs(this.getRotationSpeed()) > this.getSpeedToPowerThreshold());
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean instantKill;
        if (this.method_37908().field_9236 || this.method_31481()) {
            return true;
        }
        if (this.method_5679(source)) {
            return false;
        }
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.method_5785();
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() + amount * 10.0f);
        this.method_32875((class_6880)class_5712.field_28736, source.method_5529());
        boolean bl = instantKill = source.method_5529() instanceof class_1657 && ((class_1657)source.method_5529()).method_31549().field_7477;
        if (instantKill) {
            this.method_31472();
            return true;
        }
        if (this.getDamageWobbleStrength() > 40.0f) {
            this.destroyWithDrop();
        }
        return true;
    }

    public void destroyWithDrop() {
        if (this.method_31481()) {
            return;
        }
        this.method_5699(this.method_31480(), 0.5f);
        this.method_5768();
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        this.setHostAxlePower(false);
    }

    protected void setHostAxlePower(boolean powered) {
        class_1937 world = this.method_37908();
        class_2338 pos = this.method_24515();
        class_2680 hostBlockState = world.method_8320(pos);
        if (!powered && hostBlockState.method_27852(BwtBlocks.axlePowerSourceBlock)) {
            world.method_8650(pos, false);
            world.method_8501(pos, (class_2680)BwtBlocks.axleBlock.method_9564().method_11657((class_2769)AxleBlock.field_11459, (Comparable)((class_2350.class_2351)hostBlockState.method_11654((class_2769)AxleBlock.field_11459))));
        }
        if (powered && hostBlockState.method_27852(BwtBlocks.axleBlock)) {
            world.method_8501(pos, (class_2680)BwtBlocks.axlePowerSourceBlock.method_9564().method_11657((class_2769)AxleBlock.field_11459, (Comparable)((class_2350.class_2351)hostBlockState.method_11654((class_2769)AxleBlock.field_11459))));
        }
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10548("rotationSpeed", ((Float)this.field_6011.method_12789(rotationSpeed)).floatValue());
    }

    protected void method_5749(class_2487 nbt) {
        this.field_6011.method_12778(rotationSpeed, (Object)Float.valueOf(nbt.method_10583("rotationSpeed")));
    }

    public static interface Factory {
        public HorizontalMechPowerSourceEntity create(class_1937 var1, class_243 var2, class_2350 var3);
    }
}

