/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.entities;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.pulley.PulleyBlockEntity;
import com.bwt.entities.BwtEntities;
import com.bwt.mixin.MovableBlockEntityMixin;
import com.bwt.utils.TrackedDataHandlers;
import com.bwt.utils.VoxelShapedEntity;
import com.bwt.utils.rectangular_entity.EntityRectDimensions;
import com.bwt.utils.rectangular_entity.RectangularEntity;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1530;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class MovingRopeEntity
extends RectangularEntity
implements VoxelShapedEntity {
    protected static final class_2940<class_2338> pulleyPos = class_2945.method_12791(MovingRopeEntity.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Integer> targetY = class_2945.method_12791(MovingRopeEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> up = class_2945.method_12791(MovingRopeEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Map<class_2382, class_2680>> blockMap = class_2945.method_12791(MovingRopeEntity.class, TrackedDataHandlers.blockStateMapHandler);
    private static final class_2940<Map<class_2382, class_2487>> blockEntityNbtMap = class_2945.method_12791(MovingRopeEntity.class, TrackedDataHandlers.blockEntityMapHandler);
    private class_265 voxelShape = class_259.method_1077();
    private final float speed = 0.05f;

    public MovingRopeEntity(class_1299<? extends MovingRopeEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_23807 = true;
    }

    public MovingRopeEntity(class_1937 world, class_2338 pulley, class_2338 source, int targetY) {
        this((class_1299<? extends MovingRopeEntity>)BwtEntities.movingRopeEntity, world);
        this.setTargetY(targetY);
        if (source != null) {
            this.setIsMovingUp(source.method_10264() < targetY);
            this.method_5814((double)source.method_10263() + 0.5, source.method_10264(), (double)source.method_10260() + 0.5);
        }
        this.field_5985 = true;
        this.setPulleyPos(pulley);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(pulleyPos, (Object)class_2338.field_10980);
        builder.method_56912(up, (Object)false);
        builder.method_56912(targetY, (Object)0);
        builder.method_56912(blockMap, (Object)Maps.newHashMap());
        builder.method_56912(blockEntityNbtMap, (Object)Maps.newHashMap());
    }

    public void setPulleyPos(class_2338 pos) {
        this.field_6011.method_12778(pulleyPos, (Object)pos);
    }

    public class_2338 getPulleyPos() {
        return (class_2338)this.field_6011.method_12789(pulleyPos);
    }

    public boolean isMovingUp() {
        return (Boolean)this.field_6011.method_12789(up);
    }

    public void setIsMovingUp(boolean value) {
        this.field_6011.method_12778(up, (Object)value);
    }

    public int getTargetY() {
        return (Integer)this.field_6011.method_12789(targetY);
    }

    public void setTargetY(int value) {
        this.field_6011.method_12778(targetY, (Object)value);
    }

    public void setBlockMap(Map<class_2382, class_2680> map) {
        this.field_6011.method_12778(blockMap, map);
    }

    public HashMap<class_2382, class_2680> getBlockMap() {
        Map blockMap = (Map)this.field_6011.method_12789(MovingRopeEntity.blockMap);
        return new HashMap<class_2382, class_2680>(blockMap);
    }

    public void setBlockEntityNbtMap(Map<class_2382, class_2487> map) {
        this.field_6011.method_12778(blockEntityNbtMap, map);
    }

    public HashMap<class_2382, class_2487> getBlockEntityNbtMap() {
        Map nbtMap = (Map)this.field_6011.method_12789(blockEntityNbtMap);
        return new HashMap<class_2382, class_2487>(nbtMap);
    }

    public boolean method_5740() {
        return true;
    }

    public void method_5814(double x, double y, double z) {
        super.method_5814(x, y, z);
    }

    @Override
    public class_265 getVoxelShape() {
        return this.voxelShape;
    }

    public void setVoxelShape(class_265 voxelShape) {
        this.voxelShape = voxelShape;
        this.method_5857(voxelShape.method_1107());
        this.method_18382();
        this.method_33332();
    }

    @Override
    public EntityRectDimensions getRectDimensions() {
        class_238 boundingBox = this.method_5829();
        return EntityRectDimensions.fixed((float)boundingBox.method_17939(), (float)boundingBox.method_17940(), (float)boundingBox.method_17941());
    }

    @Override
    protected class_238 method_33332() {
        return class_238.method_54784((class_2338)new class_2338(this.getBlockMap().keySet().stream().mapToInt(class_2382::method_10263).min().orElse(0), this.getBlockMap().keySet().stream().mapToInt(class_2382::method_10264).min().orElse(0), this.getBlockMap().keySet().stream().mapToInt(class_2382::method_10260).min().orElse(0)), (class_2338)new class_2338(this.getBlockMap().keySet().stream().mapToInt(class_2382::method_10263).max().orElse(0), this.getBlockMap().keySet().stream().mapToInt(class_2382::method_10264).max().orElse(0), this.getBlockMap().keySet().stream().mapToInt(class_2382::method_10260).max().orElse(0))).method_997(this.method_19538()).method_989(-0.5, 0.0, -0.5);
    }

    public double method_23320() {
        return -1.0;
    }

    protected void method_5749(class_2487 compound) {
        this.setPulleyPos(new class_2338(compound.method_10550("PulleyX"), compound.method_10550("PulleyY"), compound.method_10550("PulleyZ")));
        this.setTargetY(compound.method_10550("TargetY"));
        this.setIsMovingUp(compound.method_10577("Up"));
        if (compound.method_10573("blocks", 9)) {
            Map<class_2382, class_2680> blocks = this.deserializeBlockMap(compound.method_10554("blocks", 10));
            this.setBlockMap(blocks);
            this.rebuildBlockBoundingBox();
        }
        if (compound.method_10573("blockEntities", 9)) {
            this.setBlockEntityNbtMap(this.deserializeBlockEntities(compound.method_10554("blockEntities", 10)));
        }
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10569("PulleyX", this.getPulleyPos().method_10263());
        compound.method_10569("PulleyY", this.getPulleyPos().method_10264());
        compound.method_10569("PulleyZ", this.getPulleyPos().method_10260());
        compound.method_10569("TargetY", this.getTargetY());
        compound.method_10556("Up", this.isMovingUp());
        compound.method_10566("blocks", (class_2520)this.serializeBlockMap());
        compound.method_10566("blockEntities", (class_2520)this.serializeBlockEntities());
    }

    private class_2499 serializeBlockEntities() {
        class_2499 entries = new class_2499();
        this.getBlockEntityNbtMap().forEach((offset, blockEntity) -> {
            class_2487 entry = new class_2487();
            entry.method_10544("offset", new class_2338(offset).method_10063());
            entry.method_10566("blockEntity", (class_2520)blockEntity);
            entries.add((Object)entry);
        });
        return entries;
    }

    private Map<class_2382, class_2487> deserializeBlockEntities(class_2499 blockEntities) {
        HashMap<class_2382, class_2487> map = new HashMap<class_2382, class_2487>();
        for (class_2520 entry : blockEntities) {
            class_2487 compound = (class_2487)entry;
            map.put((class_2382)class_2338.method_10092((long)compound.method_10537("offset")), compound.method_10562("blockEntity"));
        }
        return map;
    }

    private class_2499 serializeBlockMap() {
        class_2499 entries = new class_2499();
        for (Map.Entry<class_2382, class_2680> entry : this.getBlockMap().entrySet()) {
            if (entry.getValue() == null) continue;
            class_2487 listEntry = new class_2487();
            listEntry.method_10544("pos", new class_2338(entry.getKey()).method_10063());
            listEntry.method_10566("state", (class_2520)class_2512.method_10686((class_2680)entry.getValue()));
            entries.add((Object)listEntry);
        }
        return entries;
    }

    private Map<class_2382, class_2680> deserializeBlockMap(class_2499 blocks) {
        HashMap<class_2382, class_2680> map = new HashMap<class_2382, class_2680>();
        for (class_2520 entry : blocks) {
            class_2487 entryCompound = (class_2487)entry;
            class_2338 pos = class_2338.method_10092((long)entryCompound.method_10537("pos"));
            class_2680 state = class_2512.method_10681((class_7871)this.method_37908().method_45448(class_7924.field_41254), (class_2487)entryCompound.method_10562("state"));
            map.put((class_2382)pos, state);
        }
        return map;
    }

    public boolean method_30632(class_2338 pos, class_2680 state) {
        class_265 voxelShape2 = state.method_26194((class_1922)this.method_37908(), pos, class_3726.method_16195((class_1297)this)).method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        return class_259.method_1074((class_265)voxelShape2, (class_265)class_259.method_1078((class_238)this.method_5829()), (class_247)class_247.field_16896);
    }

    public void rebuildBlockBoundingBox() {
        HashMap<class_2382, class_2680> blocks = this.getBlockMap();
        if (blocks == null || blocks.isEmpty()) {
            this.setVoxelShape(class_259.method_1077());
            return;
        }
        class_265 newShape = class_259.method_1073();
        for (Map.Entry<class_2382, class_2680> entry : blocks.entrySet()) {
            newShape = class_259.method_1084((class_265)newShape, (class_265)entry.getValue().method_26220((class_1922)this.method_37908(), this.method_24515().method_10081(entry.getKey())).method_1096((double)entry.getKey().method_10263(), (double)entry.getKey().method_10264(), (double)entry.getKey().method_10260()));
        }
        this.setVoxelShape(newShape);
    }

    private double getSpeed() {
        return this.isMovingUp() ? (double)0.05f : (double)-0.05f;
    }

    public boolean method_30949(class_1297 other) {
        return other instanceof MovingRopeEntity;
    }

    public void method_5773() {
        if (this.getPulleyPos() == null) {
            return;
        }
        this.rebuildBlockBoundingBox();
        if (this.isMovingUp() ? this.method_23318() > (double)this.getTargetY() && this.done() : this.method_23318() < (double)this.getTargetY() && this.done()) {
            return;
        }
        HashMap<class_1297, class_238> riders = this.getRiders();
        this.moveRiders(riders);
        this.method_5814((double)this.getPulleyPos().method_10263() + 0.5, this.method_23318() + this.getSpeed(), (double)this.getPulleyPos().method_10260() + 0.5);
        riders = this.getRiders();
        this.moveRiders(riders);
    }

    public HashMap<class_1297, class_238> getRiders() {
        HashMap<class_1297, class_238> entities = new HashMap<class_1297, class_238>();
        for (class_238 box : this.getVoxelShape().method_1096(this.method_23317() - 0.5, this.method_23318(), this.method_23321() - 0.5).method_1090()) {
            for (class_1297 entity1 : this.method_37908().method_8333((class_1297)this, box.method_1009(1.0E-7, 0.15, 1.0E-7), class_1301.field_6155.and(entity -> !(entity instanceof class_1530)))) {
                entities.put(entity1, box);
            }
        }
        return entities;
    }

    public void moveRiders(HashMap<class_1297, class_238> riders) {
        riders.forEach((entity, box) -> {
            double nextFrameIntersectingY;
            if (entity.method_23318() < box.field_1322) {
                return;
            }
            double thisFrameIntersectingY = entity.method_23318() - box.field_1325;
            if (thisFrameIntersectingY < 0.0) {
                entity.method_5814(entity.method_23317(), box.field_1325 + 1.0E-7, entity.method_23321());
            }
            if ((nextFrameIntersectingY = entity.method_18798().field_1351) < 0.0) {
                entity.method_5762(0.0, -nextFrameIntersectingY, 0.0);
            }
            entity.method_5762(0.0, this.getSpeed() - entity.method_18798().field_1351, 0.0);
            entity.method_24830(true);
        });
    }

    public boolean method_5862() {
        return false;
    }

    private void reconstruct() {
        class_2338 pos = this.getPulleyPos().method_10087(this.getPulleyPos().method_10264() - this.getTargetY());
        int retries = 0;
        HashMap<class_2382, class_2680> blocks = this.getBlockMap();
        HashMap<class_2382, class_2487> blockEntities = this.getBlockEntityNbtMap();
        while (!blocks.isEmpty() && retries < 10) {
            ++retries;
            int skipped = 0;
            for (Map.Entry entry : blocks.entrySet()) {
                class_2338 blockPos2 = pos.method_10081((class_2382)entry.getKey());
                class_2680 state2 = (class_2680)entry.getValue();
                if (state2.method_26184((class_4538)this.method_37908(), blockPos2)) {
                    class_2586 blockEntity;
                    if (this.method_37908().method_8652(blockPos2, state2, 3)) {
                        ((class_3218)this.method_37908()).method_14178().method_18754((class_1297)this, (class_2596)new class_2626(blockPos2, this.method_37908().method_8320(blockPos2)));
                    }
                    if (blockEntities.containsKey(entry.getKey()) && (blockEntity = this.method_37908().method_8321(blockPos2)) != null) {
                        class_2487 tag = (class_2487)blockEntities.get(entry.getKey());
                        blockEntity.method_58690(tag, (class_7225.class_7874)this.method_56673());
                        ((MovableBlockEntityMixin)blockEntity).setPos(blockPos2);
                    }
                    blocks.remove(entry.getKey());
                    blockEntities.remove(entry.getKey());
                    skipped = 0;
                    break;
                }
                ++skipped;
            }
            if (skipped != 0) continue;
            retries = 0;
        }
        if (retries > 0) {
            blocks.forEach((blockPos, state) -> this.method_5706((class_1935)state.method_26204()));
        }
        this.setBlockMap(blocks);
    }

    private boolean done() {
        if (this.method_37908().field_9236) {
            return false;
        }
        class_2586 blockEntity = this.method_37908().method_8321(this.getPulleyPos());
        if (blockEntity instanceof PulleyBlockEntity) {
            PulleyBlockEntity pulleyBlockEntity = (PulleyBlockEntity)blockEntity;
            if (!pulleyBlockEntity.onJobCompleted(this.method_37908(), this.getPulleyPos(), this.method_37908().method_8320(this.getPulleyPos()), this.isMovingUp(), this.getTargetY())) {
                this.reconstruct();
                return true;
            }
            return false;
        }
        this.reconstruct();
        this.method_31472();
        return true;
    }

    public Map<class_2382, class_2680> addBlock(class_2382 offset, class_1937 world, class_2338 pos, class_2680 state) {
        class_2586 blockEntity = world.method_8321(pos);
        HashMap<class_2382, class_2680> blocks = this.getBlockMap();
        HashMap<class_2382, class_2487> blockEntities = this.getBlockEntityNbtMap();
        blocks.put(offset, state);
        if (blockEntity != null) {
            class_2487 tag = blockEntity.method_38242((class_7225.class_7874)this.method_56673());
            blockEntities.put(offset, tag);
            world.method_8544(pos);
            this.setBlockEntityNbtMap(blockEntities);
        }
        if (!world.field_9236) {
            this.setBlockMap(blocks);
        }
        return blocks;
    }

    protected boolean method_5818(class_1297 passenger) {
        return false;
    }

    public boolean isPathBlocked() {
        HashSet blocked = new HashSet();
        this.getBlockMap().forEach((offset, state) -> {
            if (state.method_27852(BwtBlocks.anchorBlock) && (!blocked.isEmpty() || this.isMovingUp())) {
                return;
            }
            class_2338 pos = this.getPulleyPos().method_10087(this.getPulleyPos().method_10264() - this.getTargetY()).method_10081(offset);
            pos = this.isMovingUp() ? pos.method_10084() : pos.method_10074();
            class_2680 placementState = this.method_5770().method_8320(pos);
            if (!placementState.method_26164(class_3481.field_51989) && !placementState.method_45474()) {
                blocked.add(pos);
            }
        });
        return !blocked.isEmpty();
    }
}

