/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.generation;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.MaterialInheritedBlock;
import com.bwt.entities.BwtEntities;
import com.bwt.gamerules.BwtGameRules;
import com.bwt.items.BwtItems;
import com.bwt.sounds.BwtSoundEvents;
import com.bwt.tags.BwtFluidTags;
import com.bwt.tags.BwtItemTags;
import com.bwt.utils.DyeUtils;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_3414;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import org.apache.commons.lang3.StringUtils;

public class LangGenerator
extends FabricLanguageProvider {
    public LangGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, registryLookup);
    }

    public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.addSubtitles(translationBuilder);
        this.addTagNames(translationBuilder);
        this.addEmiNames(translationBuilder);
        this.addCanvasDetails(translationBuilder);
        translationBuilder.add("death.attack.bwt.saw", "%1$s was sawed in half");
        translationBuilder.add(BwtGameRules.LENS_BEAM_RANGE.method_27334(), "Lens Beam Range");
        translationBuilder.add(BwtGameRules.LENS_BEAM_RANGE.method_27334() + ".description", "Impacts performance!");
        translationBuilder.add("container.bwt.soul_forge", "Soul Forge");
        BwtBlocks.sidingBlocks.forEach(block -> this.addMaterialBlockName(translationBuilder, (MaterialInheritedBlock)((Object)block), "siding"));
        BwtBlocks.mouldingBlocks.forEach(block -> this.addMaterialBlockName(translationBuilder, (MaterialInheritedBlock)((Object)block), "moulding"));
        BwtBlocks.cornerBlocks.forEach(block -> this.addMaterialBlockName(translationBuilder, (MaterialInheritedBlock)((Object)block), "corner"));
        BwtBlocks.columnBlocks.forEach(block -> this.addMaterialBlockName(translationBuilder, (MaterialInheritedBlock)((Object)block), "column"));
        BwtBlocks.pedestalBlocks.forEach(block -> this.addMaterialBlockName(translationBuilder, (MaterialInheritedBlock)((Object)block), "pedestal"));
        BwtBlocks.tableBlocks.forEach(block -> this.addMaterialBlockName(translationBuilder, (MaterialInheritedBlock)((Object)block), "table"));
        translationBuilder.add((class_2248)BwtBlocks.aqueductBlock, "Aqueduct");
        translationBuilder.add(BwtBlocks.hopperBlock, "Mechanical Hopper");
        translationBuilder.add(BwtBlocks.bloodWoodBlocks.logBlock, "Blood Wood Log");
        translationBuilder.add(BwtBlocks.bloodWoodBlocks.strippedLogBlock, "Stripped Blood Wood Log");
        translationBuilder.add(BwtBlocks.bloodWoodBlocks.woodBlock, "Blood Wood");
        translationBuilder.add(BwtBlocks.bloodWoodBlocks.strippedWoodBlock, "Stripped Blood Wood");
        translationBuilder.add(BwtBlocks.bloodWoodBlocks.leavesBlock, "Blood Wood Leaves");
        translationBuilder.add(BwtBlocks.bloodWoodBlocks.saplingBlock, "Blood Wood Sapling");
        translationBuilder.add(BwtBlocks.bloodWoodBlocks.planksBlock, "Blood Wood Planks");
        translationBuilder.add(BwtBlocks.bloodWoodBlocks.buttonBlock, "Blood Wood Button");
        translationBuilder.add(BwtBlocks.bloodWoodBlocks.fenceBlock, "Blood Wood Fence");
        translationBuilder.add(BwtBlocks.bloodWoodBlocks.fenceGateBlock, "Blood Wood Fence Gate");
        translationBuilder.add(BwtBlocks.bloodWoodBlocks.pressurePlateBlock, "Blood Wood Pressure Plate");
        translationBuilder.add(BwtBlocks.bloodWoodBlocks.slabBlock, "Blood Wood Slab");
        translationBuilder.add(BwtBlocks.bloodWoodBlocks.stairsBlock, "Blood Wood Stairs");
        translationBuilder.add(BwtBlocks.bloodWoodBlocks.doorBlock, "Blood Wood Door");
        translationBuilder.add(BwtBlocks.bloodWoodBlocks.trapdoorBlock, "Blood Wood Trapdoor");
        translationBuilder.add((class_2248)BwtBlocks.unfiredDecoratedPotBlock, "Unfired Decorated Pot");
        translationBuilder.add((class_2248)BwtBlocks.unfiredDecoratedPotBlockWithSherds, "Unfired Decorated Pot");
        translationBuilder.add((class_2248)BwtBlocks.unfiredCrucibleBlock, "Unfired Crucible");
        translationBuilder.add((class_2248)BwtBlocks.unfiredPlanterBlock, "Unfired Planter");
        translationBuilder.add((class_2248)BwtBlocks.unfiredVaseBlock, "Unfired Vase");
        translationBuilder.add((class_2248)BwtBlocks.unfiredUrnBlock, "Unfired Urn");
        translationBuilder.add((class_2248)BwtBlocks.unfiredFlowerPotBlock, "Unfired Flower Pot");
        translationBuilder.add(BwtBlocks.wickerBlock, "Wicker Block");
        translationBuilder.add(BwtBlocks.wickerSlabBlock, "Wicker Slab");
        translationBuilder.add(BwtBlocks.ropeCoilBlock, "Rope Block");
        translationBuilder.add(BwtBlocks.paddingBlock, "Padding Block");
        translationBuilder.add(BwtBlocks.dungBlock, "Dung Block");
        translationBuilder.add(BwtBlocks.concentratedHellfireBlock, "Concentrated Hellfire Block");
        translationBuilder.add(BwtBlocks.soapBlock, "Soap Block");
        BwtBlocks.vaseBlocks.entrySet().stream().sorted(DyeUtils.COMPARE_DYE_COLOR_ENTRY).forEach(entry -> translationBuilder.add((class_2248)entry.getValue(), LangGenerator.nameKeyToTitleCase(((class_1767)entry.getKey()).method_7792() + "_vase")));
        BwtBlocks.woolSlabBlocks.entrySet().stream().sorted(DyeUtils.COMPARE_DYE_COLOR_ENTRY).forEach(entry -> translationBuilder.add((class_2248)entry.getValue(), LangGenerator.nameKeyToTitleCase(((class_1767)entry.getKey()).method_7792() + "_wool_slab")));
        translationBuilder.add(BwtBlocks.soilPlanterBlock, "Soil Planter");
        translationBuilder.add(BwtBlocks.soulSandPlanterBlock, "Soul Sand Planter");
        translationBuilder.add((class_2248)BwtBlocks.stokedFireBlock, "Stoked Fire");
        translationBuilder.add(BwtBlocks.grassPlanterBlock, "Grass Planter");
        translationBuilder.add(BwtBlocks.stoneDetectorRailBlock, "Stone Detector Rail");
        translationBuilder.add(BwtBlocks.obsidianDetectorRailBlock, "Obsidian Detector Rail");
        translationBuilder.add(BwtBlocks.soulForgeBlock, "Soul Forge");
        translationBuilder.add(BwtBlocks.vineTrapBlock, "Vine Trap");
        translationBuilder.add(BwtBlocks.grassSlabBlock, "Grass Slab");
        translationBuilder.add(BwtBlocks.dirtSlabBlock, "Dirt Slab");
        translationBuilder.add(BwtBlocks.myceliumSlabBlock, "Mycelium Slab");
        translationBuilder.add(BwtBlocks.podzolSlabBlock, "Podzol Slab");
        translationBuilder.add(BwtBlocks.dirtPathSlabBlock, "Dirt Path Slab");
        translationBuilder.add(BwtBlocks.netherGroth, "Nether Groth Spores");
        translationBuilder.add(BwtBlocks.grothedNetherrackBlock, "Grothed Netherrack");
        translationBuilder.add(BwtBlocks.redstoneClutchBlock, "Redstone Clutch");
        translationBuilder.add(BwtItems.rawEggItem, "Raw Egg");
        translationBuilder.add(BwtItems.friedEggItem, "Fried Egg");
        translationBuilder.add(BwtItems.poachedEggItem, "Poached Egg");
        translationBuilder.add(BwtItems.screwItem, "Screw");
        translationBuilder.add(BwtItems.breedingHarnessItem, "Breeding Harness");
        translationBuilder.add(BwtItems.netheriteMattockItem, "Netherite Mattock");
        translationBuilder.add(BwtItems.netheriteBattleAxeItem, "Netherite Battle Axe");
        translationBuilder.add(BwtItems.canvasItem, "Canvas");
        translationBuilder.add(BwtEntities.broadheadArrowEntity, "Broadhead Arrow");
        translationBuilder.add(BwtEntities.dynamiteEntity, "Dynamite");
        translationBuilder.add(BwtEntities.miningChargeEntity, "Mining Charge");
        translationBuilder.add(BwtEntities.movingRopeEntity, "Moving Rope");
        translationBuilder.add(BwtEntities.rottedArrowEntity, "Rotted Arrow");
        translationBuilder.add(BwtEntities.waterWheelEntity, "Water Wheel");
        translationBuilder.add(BwtEntities.windmillEntity, "Windmill");
        translationBuilder.add(BwtEntities.canvasEntity, "Canvas");
        try {
            Path existingFilePath = (Path)this.dataOutput.getModContainer().findPath("assets/bwt/lang/en_us.existing.json").get();
            translationBuilder.add(existingFilePath);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add existing language file!", e);
        }
    }

    protected void addCanvasDetails(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        translationBuilder.add("canvas.random", "Random variant");
        translationBuilder.add("canvas.dimensions", "%sx%s");
        translationBuilder.add("canvas.bwt.wanderer.title", "Wanderer");
        translationBuilder.add("canvas.bwt.wanderer.author", "Stohun");
        translationBuilder.add("canvas.bwt.gifts.title", "Gifts");
        translationBuilder.add("canvas.bwt.gifts.author", "Stohun");
        translationBuilder.add("canvas.bwt.windmill.title", "Windmill");
        translationBuilder.add("canvas.bwt.windmill.author", "Stohun");
    }

    protected void addTagNames(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.addTagName(BwtItemTags.SIDING_BLOCKS, "Siding Blocks", translationBuilder);
        this.addTagName(BwtItemTags.WOODEN_SIDING_BLOCKS, "Wooden Siding Blocks", translationBuilder);
        this.addTagName(BwtItemTags.MOULDING_BLOCKS, "Moulding Blocks", translationBuilder);
        this.addTagName(BwtItemTags.WOODEN_MOULDING_BLOCKS, "Wooden Moulding Blocks", translationBuilder);
        this.addTagName(BwtItemTags.CORNER_BLOCKS, "Corner Blocks", translationBuilder);
        this.addTagName(BwtItemTags.COLUMN_BLOCKS, "Column Blocks", translationBuilder);
        this.addTagName(BwtItemTags.PEDESTAL_BLOCKS, "Pedestal Blocks", translationBuilder);
        this.addTagName(BwtItemTags.TABLE_BLOCKS, "Table Blocks", translationBuilder);
        this.addTagName(BwtItemTags.WOODEN_COLUMN_BLOCKS, "Wooden Column Blocks", translationBuilder);
        this.addTagName(BwtItemTags.WOODEN_PEDESTAL_BLOCKS, "Wooden Pedestal Blocks", translationBuilder);
        this.addTagName(BwtItemTags.WOODEN_TABLE_BLOCKS, "Wooden Table Blocks", translationBuilder);
        this.addTagName(BwtItemTags.VASES, "Vases", translationBuilder);
        this.addTagName(BwtItemTags.WOOL_SLABS, "Wool Slabs", translationBuilder);
        this.addTagName(BwtItemTags.WOODEN_CORNER_BLOCKS, "Wooden Corner Blocks", translationBuilder);
        this.addTagName(BwtItemTags.PASSES_WICKER_FILTER, "Passes Wicker Filter", translationBuilder);
        this.addTagName(BwtItemTags.PASSES_GRATE_FILTER, "Passes Grate Filter", translationBuilder);
        this.addTagName(BwtItemTags.PASSES_SLATS_FILTER, "Passes Slats Filter", translationBuilder);
        this.addTagName(BwtItemTags.PASSES_TRAPDOOR_FILTER, "Passes Trapdoor Filter", translationBuilder);
        this.addTagName(BwtItemTags.PASSES_IRON_BARS_FILTER, "Passes Iron Bars Filter", translationBuilder);
        this.addTagName(BwtItemTags.PASSES_LADDER_FILTER, "Passes Ladder Filter", translationBuilder);
        this.addTagName(BwtItemTags.STOKED_EXPLOSIVES, "Stoked Explosives", translationBuilder);
        this.addTagName(BwtItemTags.SAW_DUSTS, "Saw Dusts", translationBuilder);
        this.addTagName(BwtItemTags.MINING_CHARGE_IMMUNE, "Mining Charge Immune", translationBuilder);
        this.addTagName(BwtItemTags.BLOOD_WOOD_LOGS, "Blood Wood Logs", translationBuilder);
        this.addTagName(BwtItemTags.NETHER_GROTH_CAN_EAT, "Nether Groth Can Eat", translationBuilder);
        this.addTagName(BwtFluidTags.AQUEDUCT_FLUIDS, "Aqueduct Fluids", translationBuilder);
    }

    protected void addEmiNames(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.addEmiCategory("crucible", "Crucible", translationBuilder);
        this.addEmiCategory("stoked_crucible", "Stoked Crucible", translationBuilder);
        this.addEmiCategory("stoked_crucible_reclaim", "Stoked Crucible: Reclaim", translationBuilder);
        this.addEmiCategory("cauldron", "Cauldron", translationBuilder);
        this.addEmiCategory("stoked_cauldron", "Stoked Cauldron", translationBuilder);
        this.addEmiCategory("mill_stone", "Mill Stone", translationBuilder);
        this.addEmiCategory("saw", "Saw", translationBuilder);
        this.addEmiCategory("soul_forge", "Soul Forge", translationBuilder);
        this.addEmiCategory("turntable", "Turntable", translationBuilder);
        this.addEmiCategory("kiln", "Kiln", translationBuilder);
        this.addEmiCategory("hopper_souls", "Hopper: Soul Extraction", translationBuilder);
        this.addEmiCategory("hopper_filtering", "Hopper: Filter", translationBuilder);
        translationBuilder.add("emi.tooltip.bwt.hopper_souls_power", "Mechanical Power to the Hopper is advised.");
    }

    protected void addEmiCategory(String key, String name, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        translationBuilder.add("emi.category.bwt." + key, name);
    }

    protected void addSubtitles(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.addSubtitle(BwtSoundEvents.MECH_BANG, "Mechanical device operates", translationBuilder);
        this.addSubtitle(BwtSoundEvents.MECH_EXPLODE, "Mechanical device explodes", translationBuilder);
        this.addSubtitle(BwtSoundEvents.MECH_CREAK, "Mechanical device creaks", translationBuilder);
        this.addSubtitle(BwtSoundEvents.ANCHOR_RETRACT, "Anchor retracts rope", translationBuilder);
        this.addSubtitle(BwtSoundEvents.BELLOWS_COMPRESS, "Bellows compresses", translationBuilder);
        this.addSubtitle(BwtSoundEvents.COMPANION_CUBE_DEATH, "Companion cube dies. You monster.", translationBuilder);
        this.addSubtitle(BwtSoundEvents.COMPANION_CUBE_WHINE, "Companion cube whines", translationBuilder);
        this.addSubtitle(BwtSoundEvents.GEAR_BOX_ACTIVATE, "Gear box activates", translationBuilder);
        this.addSubtitle(BwtSoundEvents.HAND_CRANK_CLICK, "Hand crank activates", translationBuilder);
        this.addSubtitle(BwtSoundEvents.HIBACHI_IGNITE, "Hibachi ignites", translationBuilder);
        this.addSubtitle(BwtSoundEvents.DETECTOR_CLICK, "Detector block toggles", translationBuilder);
        this.addSubtitle(BwtSoundEvents.BUDDY_CLICK, "Buddy block toggles", translationBuilder);
        this.addSubtitle(BwtSoundEvents.BLOOD_WOOD_MOAN, "Blood wood moans", translationBuilder);
        this.addSubtitle(BwtSoundEvents.SOUL_CONVERSION, "Souls transmogrify", translationBuilder);
        this.addSubtitle(BwtSoundEvents.MILL_STONE_GRIND, "Mill stone grinds", translationBuilder);
        this.addSubtitle(BwtSoundEvents.TURNTABLE_SETTING_CLICK, "Turntable setting changes", translationBuilder);
        this.addSubtitle(BwtSoundEvents.TURNTABLE_TURNING_CLICK, "Turntable rotates", translationBuilder);
        this.addSubtitle(BwtSoundEvents.WOLF_DUNG_PRODUCTION, "Wolf produces dung", translationBuilder);
        this.addSubtitle(BwtSoundEvents.WOLF_DUNG_EFFORT, "Wolf growls", translationBuilder);
        this.addSubtitle(BwtSoundEvents.DYNAMITE_THROW, "Dynamite thrown", translationBuilder);
        this.addSubtitle(BwtSoundEvents.DYNAMITE_IGNITE, "Dynamite ignited", translationBuilder);
        this.addSubtitle(BwtSoundEvents.MINING_CHARGE_PRIME, "Mining charge primed", translationBuilder);
        this.addSubtitle(BwtSoundEvents.SOUL_URN_THROW, "Soul Urn thrown", translationBuilder);
    }

    protected void addSubtitle(class_3414 soundEvent, String value, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        translationBuilder.add(soundEvent.method_14833().method_45138("subtitles."), value);
    }

    protected void addTagName(class_6862<?> tagKey, String value, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        translationBuilder.add(tagKey, value);
    }

    protected void addMaterialBlockName(FabricLanguageProvider.TranslationBuilder translationBuilder, MaterialInheritedBlock materialInheritedBlock, String suffix) {
        translationBuilder.add((class_2248)materialInheritedBlock, LangGenerator.nameKeyToTitleCase(materialInheritedBlock.fullBlock.method_9539().replaceFirst("_planks", "") + "_" + suffix));
    }

    public static String nameKeyToTitleCase(String snakeString) {
        String[] split = snakeString.split("\\.");
        snakeString = split[split.length - 1];
        return Arrays.stream(snakeString.split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }
}

