/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.recipes;

import com.bwt.utils.Id;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record BlockIngredient(Optional<class_6862<class_2248>> optionalBlockTagKey, Optional<class_2248> optionalBlock) implements CustomIngredient
{
    public static final Serializer SERIALIZER = new Serializer();

    public static BlockIngredient fromBlock(class_2248 block) {
        return new BlockIngredient(Optional.empty(), Optional.of(block));
    }

    public static BlockIngredient fromTag(class_6862<class_2248> tagKey) {
        return new BlockIngredient(Optional.of(tagKey), Optional.empty());
    }

    public boolean test(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return this.test(blockItem.method_7711());
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean test(class_2248 block) {
        if (this.optionalBlockTagKey.filter(blockTagKey -> block.method_9564().method_26164(blockTagKey)).isPresent()) return true;
        if (!this.optionalBlock.filter(block::equals).isPresent()) return false;
        return true;
    }

    public List<class_1799> getMatchingStacks() {
        return List.of();
    }

    public boolean requiresTesting() {
        return true;
    }

    public CustomIngredientSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public static class Serializer
    implements CustomIngredientSerializer<BlockIngredient> {
        private static final class_2960 ID = Id.of("block_ingredient");
        public static final MapCodec<BlockIngredient> CODEC = Serializer.createCodec();
        public static final class_9139<class_9129, BlockIngredient> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        public static MapCodec<BlockIngredient> createCodec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6862.method_40093((class_5321)class_7924.field_41254).optionalFieldOf("blockTag").forGetter(blockIngredient -> blockIngredient.optionalBlockTagKey), (App)class_7923.field_41175.method_39673().optionalFieldOf("block").forGetter(blockIngredient -> blockIngredient.optionalBlock)).apply((Applicative)instance, BlockIngredient::new));
        }

        public class_2960 getIdentifier() {
            return ID;
        }

        public class_9139<class_9129, BlockIngredient> getPacketCodec() {
            return PACKET_CODEC;
        }

        public MapCodec<BlockIngredient> getCodec(boolean allowEmpty) {
            return CODEC;
        }

        public static BlockIngredient read(class_9129 buf) {
            class_2960 blockTagKeyId = buf.method_10810();
            Optional<class_6862<class_2248>> blockTagKey = blockTagKeyId.method_12836().isBlank() ? Optional.empty() : Optional.of(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)blockTagKeyId));
            class_2960 blockId = buf.method_10810();
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(blockId);
            return new BlockIngredient(blockTagKey, block.equals(class_2246.field_10124) ? Optional.empty() : Optional.of(block));
        }

        public static void write(class_9129 buf, BlockIngredient ingredient) {
            buf.method_10812(ingredient.optionalBlockTagKey.map(class_6862::comp_327).orElse(Id.of("", "")));
            buf.method_10812(ingredient.optionalBlock.map(arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0)).orElse(Id.of("", "")));
        }
    }
}

