/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.recipes.mill_stone;

import com.bwt.blocks.BwtBlocks;
import com.bwt.generation.EmiDefaultsGenerator;
import com.bwt.recipes.BwtRecipes;
import com.bwt.recipes.IngredientWithCount;
import com.bwt.recipes.mill_stone.MillStoneRecipeInput;
import com.bwt.utils.Id;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5797;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class MillStoneRecipe
implements class_1860<MillStoneRecipeInput> {
    protected final String group;
    protected final class_7710 category;
    final class_2371<IngredientWithCount> ingredients;
    protected final class_2371<class_1799> results;

    public MillStoneRecipe(String group, class_7710 category, List<IngredientWithCount> ingredients, List<class_1799> results) {
        this.group = group;
        this.category = category;
        this.ingredients = class_2371.method_10212((Object)IngredientWithCount.EMPTY, (Object[])ingredients.toArray(new IngredientWithCount[0]));
        this.results = class_2371.method_10212((Object)class_1799.field_8037, (Object[])results.toArray(new class_1799[0]));
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)BwtBlocks.millStoneBlock);
    }

    public class_1865<?> method_8119() {
        return BwtRecipes.MILL_STONE_RECIPE_SERIALIZER;
    }

    public boolean matches(MillStoneRecipeInput input, class_1937 world) {
        for (IngredientWithCount ingredient : this.ingredients) {
            Optional<Integer> matchingCount = input.items().stream().filter(stack -> ingredient.ingredient().method_8093(stack)).map(class_1799::method_7947).reduce(Integer::sum);
            if (matchingCount.orElse(0) >= ingredient.count()) continue;
            return false;
        }
        return true;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.addAll(this.ingredients.stream().map(CustomIngredient::toVanilla).toList());
        return defaultedList;
    }

    public class_2371<IngredientWithCount> getIngredientsWithCount() {
        return this.ingredients;
    }

    public List<class_1799> getResults() {
        return this.results.stream().map(class_1799::method_7972).collect(Collectors.toList());
    }

    public String method_8112() {
        return this.group;
    }

    public class_3956<?> method_17716() {
        return BwtRecipes.MILL_STONE_RECIPE_TYPE;
    }

    public class_7710 getCategory() {
        return this.category;
    }

    public boolean method_8118() {
        return true;
    }

    public boolean method_49188() {
        return false;
    }

    public class_1799 craft(MillStoneRecipeInput input, class_7225.class_7874 lookup) {
        return this.method_8110(lookup);
    }

    public class_1799 method_8110(class_7225.class_7874 wrapperLookup) {
        return (class_1799)this.results.get(0);
    }

    public static class Serializer
    implements class_1865<MillStoneRecipe> {
        protected static final MapCodec<MillStoneRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(recipe -> recipe.category), (App)IngredientWithCount.Serializer.DISALLOW_EMPTY_CODEC.codec().listOf().fieldOf("ingredients").forGetter(recipe -> recipe.ingredients), (App)class_1799.field_24671.listOf().fieldOf("results").forGetter(MillStoneRecipe::getResults)).apply((Applicative)instance, MillStoneRecipe::new));
        public static final class_9139<class_9129, MillStoneRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        public MapCodec<MillStoneRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, MillStoneRecipe> method_56104() {
            return PACKET_CODEC;
        }

        public static MillStoneRecipe read(class_9129 buf) {
            String group = buf.method_19772();
            class_7710 category = (class_7710)buf.method_10818(class_7710.class);
            int ingredientsSize = buf.method_10816();
            class_2371 ingredients = class_2371.method_10213((int)ingredientsSize, (Object)IngredientWithCount.EMPTY);
            ingredients.replaceAll(ignored -> IngredientWithCount.Serializer.read(buf));
            List results = (List)class_1799.field_48350.decode((Object)buf);
            return new MillStoneRecipe(group, category, (List<IngredientWithCount>)ingredients, results);
        }

        public static void write(class_9129 buf, MillStoneRecipe recipe) {
            buf.method_10814(recipe.group);
            buf.method_10817((Enum)recipe.category);
            buf.method_10804(recipe.ingredients.size());
            for (IngredientWithCount ingredient : recipe.ingredients) {
                IngredientWithCount.Serializer.write(buf, ingredient);
            }
            class_1799.field_48350.encode((Object)buf, recipe.getResults());
        }
    }

    public static class JsonBuilder
    implements class_5797 {
        protected class_7710 category = class_7710.field_40251;
        protected class_2371<IngredientWithCount> ingredients = class_2371.method_10211();
        protected class_2371<class_1799> results = class_2371.method_10211();
        protected final Map<String, class_175<?>> criteria = new LinkedHashMap();
        @Nullable
        protected String group;
        protected boolean isDefaultRecipe;

        public static JsonBuilder create() {
            return new JsonBuilder();
        }

        public JsonBuilder category(class_7710 category) {
            this.category = category;
            return this;
        }

        public JsonBuilder ingredients(IngredientWithCount ... ingredients) {
            for (IngredientWithCount ingredient : ingredients) {
                this.ingredient(ingredient);
            }
            return this;
        }

        public JsonBuilder ingredient(IngredientWithCount ingredient) {
            this.ingredients.add((Object)ingredient);
            return this;
        }

        public JsonBuilder ingredient(class_1799 itemStack) {
            this.criterion(class_2446.method_32807((class_1935)itemStack.method_7909()), class_2446.method_10426((class_1935)itemStack.method_7909()));
            return this.ingredient(IngredientWithCount.fromStack(itemStack));
        }

        public JsonBuilder ingredient(class_1792 item, int count) {
            return this.ingredient(new class_1799((class_1935)item, count));
        }

        public JsonBuilder ingredient(class_1792 item) {
            return this.ingredient(item, 1);
        }

        public JsonBuilder results(class_1799 ... itemStacks) {
            this.results.addAll(Arrays.asList(itemStacks));
            return this;
        }

        public JsonBuilder result(class_1799 itemStack) {
            this.results.add((Object)itemStack);
            return this;
        }

        public JsonBuilder result(class_1792 item, int count) {
            this.results.add((Object)new class_1799((class_1935)item, count));
            return this;
        }

        public JsonBuilder result(class_1792 item) {
            return this.result(item, 1);
        }

        public JsonBuilder criterion(String string, class_175<?> advancementCriterion) {
            this.criteria.put(string, advancementCriterion);
            return this;
        }

        public JsonBuilder group(@Nullable String string) {
            this.group = string;
            return this;
        }

        public JsonBuilder markDefault() {
            this.isDefaultRecipe = true;
            return this;
        }

        public void addToDefaults(class_2960 recipeId) {
            if (this.isDefaultRecipe) {
                EmiDefaultsGenerator.addBwtRecipe(recipeId.method_45138("/"));
            }
        }

        public class_1792 method_36441() {
            return ((class_1799)this.results.get(0)).method_7909();
        }

        public void method_10431(class_8790 exporter) {
            this.method_36443(exporter, class_2446.method_33716((class_1935)((class_1799)this.results.get(0)).method_7909()) + "_from_milling_" + class_2446.method_33716((class_1935)((IngredientWithCount)this.ingredients.get(0)).getMatchingStacks().get(0).method_7909()));
        }

        public void method_36443(class_8790 exporter, String recipePath) {
            this.method_17972(exporter, Id.of(recipePath));
        }

        public void method_17972(class_8790 exporter, class_2960 recipeId) {
            this.validate(recipeId);
            this.addToDefaults(recipeId);
            class_161.class_162 advancementBuilder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_8782.class_8797.field_1257);
            this.criteria.forEach((arg_0, arg_1) -> ((class_161.class_162)advancementBuilder).method_705(arg_0, arg_1));
            MillStoneRecipe millStoneRecipe = new MillStoneRecipe(Objects.requireNonNullElse(this.group, ""), this.category, (List<IngredientWithCount>)this.ingredients, (List<class_1799>)this.results);
            exporter.method_53819(recipeId, (class_1860)millStoneRecipe, advancementBuilder.method_695(recipeId.method_45138("recipes/" + this.category.method_15434() + "/")));
        }

        private void validate(class_2960 recipeId) {
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeId));
            }
        }
    }
}

