/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.utils;

import com.bwt.blocks.StokedFireBlock;
import java.util.HashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2358;
import net.minecraft.class_2680;

public class FireData {
    public static final HashMap<Class<? extends class_2248>, FireAmountFunction> FIRE_AMOUNT_FUNCTIONS = new HashMap();
    int unstokedCount;
    int stokedCount;

    public FireData(int unstokedCount, int stokedCount) {
        this.unstokedCount = unstokedCount;
        this.stokedCount = stokedCount;
    }

    public FireData(int unstokedCount) {
        this(unstokedCount, 0);
    }

    public FireData() {
        this(0);
    }

    public void add(FireData otherData) {
        this.unstokedCount += otherData.unstokedCount;
        this.stokedCount += otherData.stokedCount;
    }

    public boolean anyFirePresent() {
        return this.unstokedCount > 0 || this.stokedCount > 0;
    }

    public int getUnstokedCount() {
        return this.unstokedCount;
    }

    public int getStokedCount() {
        return this.stokedCount;
    }

    static {
        FIRE_AMOUNT_FUNCTIONS.put(class_2358.class, (world, pos, state) -> new FireData(1, 0));
        FIRE_AMOUNT_FUNCTIONS.put(StokedFireBlock.class, (world, pos, state) -> new FireData(0, 1));
    }

    public static interface FireAmountFunction {
        public static final FireAmountFunction NONE = (world, pos, state) -> new FireData();

        public FireData getFireData(class_1937 var1, class_2338 var2, class_2680 var3);
    }
}

