/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.utils;

import com.bwt.utils.BlockPosAndState;
import com.bwt.utils.FireData;
import com.bwt.utils.RadiusAroundBlockStream;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class FireDataCluster {
    public static final int primaryFireFactor = 5;
    public static final int secondaryFireFactor = 1;
    FireData fireData = new FireData();
    boolean centerBlockIsStoked = false;

    public static FireDataCluster fromWorld(class_1937 world, class_2338 pos, int radius) {
        FireDataCluster fireDataCluster = new FireDataCluster();
        class_2338 below = pos.method_10074();
        class_2680 centerState = world.method_8320(below);
        FireData centerData = FireData.FIRE_AMOUNT_FUNCTIONS.getOrDefault(centerState.method_26204().getClass(), FireData.FireAmountFunction.NONE).getFireData(world, below, centerState);
        if (!centerData.anyFirePresent()) {
            return fireDataCluster;
        }
        if (centerData.stokedCount > 0) {
            fireDataCluster.centerBlockIsStoked = true;
        }
        fireDataCluster.fireData.add(centerData);
        RadiusAroundBlockStream.neighboringBlocksInHorizontalRadius(below, radius).map(neighborPos -> BlockPosAndState.of((class_1936)world, neighborPos)).map(neighbor -> FireData.FIRE_AMOUNT_FUNCTIONS.getOrDefault(neighbor.state().method_26204().getClass(), FireData.FireAmountFunction.NONE).getFireData(world, neighbor.pos(), neighbor.state())).forEach(fireDataCluster.fireData::add);
        return fireDataCluster;
    }

    public static FireDataCluster fromWorld(class_1937 world, class_2338 pos) {
        return FireDataCluster.fromWorld(world, pos, 1);
    }

    public boolean isStoked() {
        return this.centerBlockIsStoked;
    }

    public int getUnstokedCount() {
        return this.isStoked() ? 0 : this.fireData.getUnstokedCount();
    }

    public int getStokedCount() {
        return this.isStoked() ? this.fireData.getStokedCount() : 0;
    }

    public boolean anyFirePresent() {
        return this.getUnstokedCount() > 0 || this.getStokedCount() > 0;
    }

    public int getUnstokedFactor() {
        int unstokedCount = this.getUnstokedCount();
        return unstokedCount > 0 ? 5 + (unstokedCount - 1) * 1 : 0;
    }

    public int getStokedFactor() {
        int stokedCount = this.getStokedCount();
        return stokedCount > 0 ? 5 + (stokedCount - 1) * 1 : 0;
    }

    public int getDominantFireTypeFactor() {
        return this.isStoked() ? this.getStokedFactor() : this.getUnstokedFactor();
    }
}

