/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure;

import com.mongenscave.mctreasure.boostedyaml.settings.dumper.DumperSettings;
import com.mongenscave.mctreasure.boostedyaml.settings.general.GeneralSettings;
import com.mongenscave.mctreasure.boostedyaml.settings.loader.LoaderSettings;
import com.mongenscave.mctreasure.boostedyaml.settings.updater.UpdaterSettings;
import com.mongenscave.mctreasure.bstats.bukkit.Metrics;
import com.mongenscave.mctreasure.config.Config;
import com.mongenscave.mctreasure.listener.LocationSessionListener;
import com.mongenscave.mctreasure.listener.MenuListener;
import com.mongenscave.mctreasure.listener.TreasureListener;
import com.mongenscave.mctreasure.managers.TreasureManager;
import com.mongenscave.mctreasure.particles.ParticleSystem;
import com.mongenscave.mctreasure.universalScheduler.UniversalScheduler;
import com.mongenscave.mctreasure.universalScheduler.scheduling.schedulers.TaskScheduler;
import com.mongenscave.mctreasure.update.UpdateChecker;
import com.mongenscave.mctreasure.utils.LoggerUtils;
import com.mongenscave.mctreasure.utils.RegisterUtils;
import com.mongenscave.mctreasure.zapper.ZapperJavaPlugin;
import java.io.File;
import lombok.Generated;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class McTreasure
extends ZapperJavaPlugin {
    static McTreasure instance;
    Config language;
    TaskScheduler scheduler;
    Config guis;
    Config treasures;
    ParticleSystem particleSystem;
    UpdateChecker updateChecker;
    Config config;

    public void onLoad() {
        instance = this;
        this.scheduler = UniversalScheduler.getScheduler((Plugin)this);
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.initializeComponents();
        this.getServer().getPluginManager().registerEvents((Listener)new MenuListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TreasureListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new LocationSessionListener(), (Plugin)this);
        this.particleSystem = new ParticleSystem();
        TreasureManager.getInstance().loadTreasures();
        RegisterUtils.registerCommands();
        new Metrics((JavaPlugin)this, 25975);
        this.updateChecker = new UpdateChecker(7857);
        LoggerUtils.info("McTreasure plugin successfully enabled!", new Object[0]);
    }

    public void onDisable() {
        if (TreasureManager.getInstance() != null) {
            TreasureManager.getInstance().saveTreasures();
        }
        if (this.particleSystem != null) {
            this.particleSystem.shutdown();
            this.particleSystem = null;
        }
        if (this.updateChecker != null) {
            this.updateChecker.shutdown();
            this.updateChecker = null;
        }
    }

    public Config getConfiguration() {
        return this.config;
    }

    private void initializeComponents() {
        GeneralSettings generalSettings = GeneralSettings.builder().setUseDefaults(false).build();
        LoaderSettings loaderSettings = LoaderSettings.builder().setAutoUpdate(true).build();
        UpdaterSettings updaterSettings = UpdaterSettings.builder().setKeepAll(true).build();
        this.config = this.loadConfig("config.yml", generalSettings, loaderSettings, updaterSettings);
        this.language = this.loadConfig("messages.yml", generalSettings, loaderSettings, updaterSettings);
        this.treasures = this.loadConfig("treasures.yml", generalSettings, loaderSettings, updaterSettings);
        this.guis = this.loadConfig("guis.yml", generalSettings, loaderSettings, updaterSettings);
    }

    @NotNull
    @Contract(value="_, _, _, _ -> new")
    private Config loadConfig(@NotNull String fileName, @NotNull GeneralSettings generalSettings, @NotNull LoaderSettings loaderSettings, @NotNull UpdaterSettings updaterSettings) {
        return new Config(new File(this.getDataFolder(), fileName), this.getResource(fileName), generalSettings, loaderSettings, DumperSettings.DEFAULT, updaterSettings);
    }

    @Generated
    public static McTreasure getInstance() {
        return instance;
    }

    @Generated
    public Config getLanguage() {
        return this.language;
    }

    @Generated
    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    @Generated
    public Config getGuis() {
        return this.guis;
    }

    @Generated
    public Config getTreasures() {
        return this.treasures;
    }

    @Generated
    public ParticleSystem getParticleSystem() {
        return this.particleSystem;
    }

    @Generated
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }
}

