/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.data;

import lombok.Generated;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleEffectConfiguration {
    private Location location;
    private Player player;
    private boolean visibleToAll = true;
    private int duration = 0;
    private Particle particleType = Particle.FLAME;
    private int particleCount = 1;
    private double particleSpeed = 0.0;
    private Color particleColor = Color.RED;
    private float particleSize = 1.0f;
    private double radius = 1.0;
    private double height = 2.0;
    private double rotationSpeed = 1.0;
    private double expansionRate = 0.1;
    private int density = 10;

    @NotNull
    public static ParticleEffectConfiguration at(@Nullable Location location) {
        ParticleEffectConfiguration config = new ParticleEffectConfiguration();
        config.setLocation(location);
        return config;
    }

    public ParticleEffectConfiguration particle(Particle type) {
        this.particleType = type;
        return this;
    }

    public ParticleEffectConfiguration size(float size) {
        this.particleSize = size;
        return this;
    }

    public void copyFrom(ParticleEffectConfiguration other) {
        if (other == null) {
            return;
        }
        this.location = other.location == null ? null : other.location.clone();
        this.player = other.player;
        this.visibleToAll = other.visibleToAll;
        this.duration = other.duration;
        this.particleType = other.particleType;
        this.particleCount = other.particleCount;
        this.particleSpeed = other.particleSpeed;
        this.particleColor = other.particleColor;
        this.particleSize = other.particleSize;
        this.radius = other.radius;
        this.height = other.height;
        this.rotationSpeed = other.rotationSpeed;
        this.expansionRate = other.expansionRate;
        this.density = other.density;
    }

    @Generated
    public ParticleEffectConfiguration() {
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public boolean isVisibleToAll() {
        return this.visibleToAll;
    }

    @Generated
    public int getDuration() {
        return this.duration;
    }

    @Generated
    public Particle getParticleType() {
        return this.particleType;
    }

    @Generated
    public int getParticleCount() {
        return this.particleCount;
    }

    @Generated
    public double getParticleSpeed() {
        return this.particleSpeed;
    }

    @Generated
    public Color getParticleColor() {
        return this.particleColor;
    }

    @Generated
    public float getParticleSize() {
        return this.particleSize;
    }

    @Generated
    public double getRadius() {
        return this.radius;
    }

    @Generated
    public double getHeight() {
        return this.height;
    }

    @Generated
    public double getRotationSpeed() {
        return this.rotationSpeed;
    }

    @Generated
    public double getExpansionRate() {
        return this.expansionRate;
    }

    @Generated
    public int getDensity() {
        return this.density;
    }

    @Generated
    public void setLocation(Location location) {
        this.location = location;
    }

    @Generated
    public void setPlayer(Player player) {
        this.player = player;
    }

    @Generated
    public void setVisibleToAll(boolean visibleToAll) {
        this.visibleToAll = visibleToAll;
    }

    @Generated
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Generated
    public void setParticleType(Particle particleType) {
        this.particleType = particleType;
    }

    @Generated
    public void setParticleCount(int particleCount) {
        this.particleCount = particleCount;
    }

    @Generated
    public void setParticleSpeed(double particleSpeed) {
        this.particleSpeed = particleSpeed;
    }

    @Generated
    public void setParticleColor(Color particleColor) {
        this.particleColor = particleColor;
    }

    @Generated
    public void setParticleSize(float particleSize) {
        this.particleSize = particleSize;
    }

    @Generated
    public void setRadius(double radius) {
        this.radius = radius;
    }

    @Generated
    public void setHeight(double height) {
        this.height = height;
    }

    @Generated
    public void setRotationSpeed(double rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
    }

    @Generated
    public void setExpansionRate(double expansionRate) {
        this.expansionRate = expansionRate;
    }

    @Generated
    public void setDensity(int density) {
        this.density = density;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParticleEffectConfiguration)) {
            return false;
        }
        ParticleEffectConfiguration other = (ParticleEffectConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isVisibleToAll() != other.isVisibleToAll()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.getParticleCount() != other.getParticleCount()) {
            return false;
        }
        if (Double.compare(this.getParticleSpeed(), other.getParticleSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getParticleSize(), other.getParticleSize()) != 0) {
            return false;
        }
        if (Double.compare(this.getRadius(), other.getRadius()) != 0) {
            return false;
        }
        if (Double.compare(this.getHeight(), other.getHeight()) != 0) {
            return false;
        }
        if (Double.compare(this.getRotationSpeed(), other.getRotationSpeed()) != 0) {
            return false;
        }
        if (Double.compare(this.getExpansionRate(), other.getExpansionRate()) != 0) {
            return false;
        }
        if (this.getDensity() != other.getDensity()) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        Player this$player = this.getPlayer();
        Player other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        Particle this$particleType = this.getParticleType();
        Particle other$particleType = other.getParticleType();
        if (this$particleType == null ? other$particleType != null : !this$particleType.equals(other$particleType)) {
            return false;
        }
        Color this$particleColor = this.getParticleColor();
        Color other$particleColor = other.getParticleColor();
        return !(this$particleColor == null ? other$particleColor != null : !this$particleColor.equals(other$particleColor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParticleEffectConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVisibleToAll() ? 79 : 97);
        result = result * 59 + this.getDuration();
        result = result * 59 + this.getParticleCount();
        long $particleSpeed = Double.doubleToLongBits(this.getParticleSpeed());
        result = result * 59 + (int)($particleSpeed >>> 32 ^ $particleSpeed);
        result = result * 59 + Float.floatToIntBits(this.getParticleSize());
        long $radius = Double.doubleToLongBits(this.getRadius());
        result = result * 59 + (int)($radius >>> 32 ^ $radius);
        long $height = Double.doubleToLongBits(this.getHeight());
        result = result * 59 + (int)($height >>> 32 ^ $height);
        long $rotationSpeed = Double.doubleToLongBits(this.getRotationSpeed());
        result = result * 59 + (int)($rotationSpeed >>> 32 ^ $rotationSpeed);
        long $expansionRate = Double.doubleToLongBits(this.getExpansionRate());
        result = result * 59 + (int)($expansionRate >>> 32 ^ $expansionRate);
        result = result * 59 + this.getDensity();
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        Player $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        Particle $particleType = this.getParticleType();
        result = result * 59 + ($particleType == null ? 43 : $particleType.hashCode());
        Color $particleColor = this.getParticleColor();
        result = result * 59 + ($particleColor == null ? 43 : $particleColor.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ParticleEffectConfiguration(location=" + String.valueOf(this.getLocation()) + ", player=" + String.valueOf(this.getPlayer()) + ", visibleToAll=" + this.isVisibleToAll() + ", duration=" + this.getDuration() + ", particleType=" + String.valueOf(this.getParticleType()) + ", particleCount=" + this.getParticleCount() + ", particleSpeed=" + this.getParticleSpeed() + ", particleColor=" + String.valueOf(this.getParticleColor()) + ", particleSize=" + this.getParticleSize() + ", radius=" + this.getRadius() + ", height=" + this.getHeight() + ", rotationSpeed=" + this.getRotationSpeed() + ", expansionRate=" + this.getExpansionRate() + ", density=" + this.getDensity() + ")";
    }
}

