/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.gui.models;

import com.mongenscave.mctreasure.data.MenuController;
import com.mongenscave.mctreasure.gui.Menu;
import com.mongenscave.mctreasure.identifiers.keys.MessageKeys;
import com.mongenscave.mctreasure.model.TreasureChest;
import com.mongenscave.mctreasure.processor.MessageProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TreasureInventoryMenu
extends Menu {
    private final TreasureChest chest;
    private final List<ItemStack> availableItems;
    private final ThreadLocalRandom random = ThreadLocalRandom.current();
    private boolean itemsPlaced = false;
    private boolean cooldownRecorded = false;

    public TreasureInventoryMenu(@NotNull MenuController menuController, @NotNull TreasureChest chest) {
        super(menuController);
        this.chest = chest;
        this.availableItems = Collections.synchronizedList(new ArrayList<ItemStack>(chest.getItems()));
        Collections.shuffle(this.availableItems);
    }

    @Override
    public void handleMenu(@NotNull InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        event.setCancelled(true);
        if (event.getClick().isLeftClick() || event.getClick().isRightClick()) {
            if (this.hasAvailableSlot(player)) {
                player.getInventory().addItem(new ItemStack[]{clickedItem.clone()});
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.5f, 1.2f);
                this.inventory.setItem(event.getSlot(), new ItemStack(Material.AIR));
                player.sendMessage(MessageKeys.ITEM_OBTAINED.getMessage());
                if (!this.cooldownRecorded) {
                    this.chest.recordPlayerOpen(player);
                    this.cooldownRecorded = true;
                    if (this.chest.isHologramEnabled() && this.chest.getHologramLines().stream().anyMatch(line -> line.contains("{time-left}"))) {
                        this.chest.setupHologram();
                    }
                }
            } else {
                player.sendMessage(MessageKeys.INVENTORY_FULL.getMessage());
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.5f, 1.0f);
            }
        }
    }

    @Override
    public void setMenuItems() {
        if (!this.itemsPlaced) {
            this.placeItems();
            this.itemsPlaced = true;
        }
    }

    private void placeItems() {
        this.inventory.clear();
        if (this.availableItems.isEmpty()) {
            ItemStack noItemsItem = new ItemStack(Material.PAPER);
            this.inventory.setItem(this.getSlots() / 2, noItemsItem);
            return;
        }
        int itemsToShow = Math.min(this.availableItems.size(), this.getSlots());
        List<Integer> availableSlots = this.getRandomSlots(itemsToShow);
        for (int i = 0; i < itemsToShow; ++i) {
            this.inventory.setItem(availableSlots.get(i).intValue(), this.availableItems.get(i).clone());
        }
    }

    @NotNull
    private List<Integer> getRandomSlots(int count) {
        int i;
        List<Integer> slots = Collections.synchronizedList(new ArrayList());
        List<Integer> availableSlots = Collections.synchronizedList(new ArrayList());
        for (i = 0; i < this.getSlots(); ++i) {
            availableSlots.add(i);
        }
        Collections.shuffle(availableSlots, this.random);
        for (i = 0; i < count; ++i) {
            slots.add((Integer)availableSlots.get(i));
        }
        return slots;
    }

    private boolean hasAvailableSlot(@NotNull Player player) {
        for (ItemStack item : player.getInventory().getStorageContents()) {
            if (item != null && item.getType() != Material.AIR) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        super.close();
        Player player = this.menuController.owner();
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_CLOSE, 0.5f, 1.0f);
    }

    @Override
    public String getMenuName() {
        return MessageProcessor.process(this.chest.getName());
    }

    @Override
    public int getSlots() {
        return this.chest.getSize();
    }

    @Override
    public int getMenuTick() {
        return 20;
    }
}

