/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.gui.models;

import com.mongenscave.mctreasure.data.MenuController;
import com.mongenscave.mctreasure.gui.Menu;
import com.mongenscave.mctreasure.gui.models.main.TreasureEditMenu;
import com.mongenscave.mctreasure.identifiers.keys.ItemKeys;
import com.mongenscave.mctreasure.identifiers.keys.MenuKeys;
import com.mongenscave.mctreasure.identifiers.keys.MessageKeys;
import com.mongenscave.mctreasure.managers.TreasureManager;
import com.mongenscave.mctreasure.model.TreasureChest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TreasureItemsMenu
extends Menu {
    private final TreasureChest chest;
    private List<ItemStack> items;
    private boolean isInitialized = false;

    public TreasureItemsMenu(@NotNull MenuController menuController, @NotNull TreasureChest chest) {
        super(menuController);
        this.chest = chest;
        this.items = chest.getItems();
        if (this.items == null) {
            this.items = Collections.synchronizedList(new ArrayList());
            chest.setItems(this.items);
        }
    }

    @Override
    public void handleMenu(@NotNull InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == this.getSlots() - 1) {
            event.setCancelled(true);
            this.updateItemsFromInventory();
            this.chest.setItems(this.items);
            TreasureManager.getInstance().saveTreasures();
            player.sendMessage(MessageKeys.SUCCESS_SAVE.getMessage());
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.0f);
            new TreasureEditMenu(MenuController.getMenuUtils(player), this.chest).open();
            return;
        }
        if (event.getSlot() >= this.getSlots() - 1) {
            event.setCancelled(true);
        }
    }

    @Override
    public void setMenuItems() {
        ItemStack saveItem = ItemKeys.ADD_ITEM_SAVE.getItem();
        this.inventory.setItem(this.getSlots() - 1, saveItem);
        if (!this.isInitialized) {
            for (int i = 0; i < this.items.size() && i < this.getSlots() - 1; ++i) {
                ItemStack item = this.items.get(i);
                if (item == null || item.getType() == Material.AIR) continue;
                this.inventory.setItem(i, item.clone());
            }
            this.isInitialized = true;
        }
    }

    private void updateItemsFromInventory() {
        if (this.inventory == null) {
            return;
        }
        List<ItemStack> updatedItems = Collections.synchronizedList(new ArrayList());
        for (int i = 0; i < this.getSlots() - 1; ++i) {
            ItemStack currentItem = this.inventory.getItem(i);
            if (currentItem == null || currentItem.getType() == Material.AIR) continue;
            updatedItems.add(currentItem.clone());
        }
        this.items = updatedItems;
    }

    @Override
    public String getMenuName() {
        return MenuKeys.MENU_ADD_ITEM_TITLE.getString();
    }

    @Override
    public int getSlots() {
        return this.chest.getSize() > 0 ? this.chest.getSize() : 54;
    }

    @Override
    public int getMenuTick() {
        return 5;
    }
}

