/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.gui.models;

import com.mongenscave.mctreasure.data.MenuController;
import com.mongenscave.mctreasure.gui.Menu;
import com.mongenscave.mctreasure.gui.models.main.TreasureEditMenu;
import com.mongenscave.mctreasure.identifiers.keys.MenuKeys;
import com.mongenscave.mctreasure.model.TreasureChest;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TreasurePreviewMenu
extends Menu {
    private final TreasureChest chest;
    private final List<ItemStack> items;

    public TreasurePreviewMenu(@NotNull MenuController menuController, @NotNull TreasureChest chest) {
        super(menuController);
        this.chest = chest;
        this.items = chest.getItems();
    }

    @Override
    public void handleMenu(@NotNull InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        event.setCancelled(true);
        if (event.getSlot() == this.getSlots() - 1) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
            new TreasureEditMenu(MenuController.getMenuUtils(player), this.chest).open();
        }
    }

    @Override
    public void setMenuItems() {
        for (int i = 0; i < this.items.size() && i < this.getSlots() - 1; ++i) {
            this.inventory.setItem(i, this.items.get(i));
        }
        ItemStack backButton = new ItemStack(Material.ARROW);
        this.inventory.setItem(this.getSlots() - 1, backButton);
    }

    @Override
    public String getMenuName() {
        return MenuKeys.MENU_PREVIEW_TITLE.getString();
    }

    @Override
    public int getSlots() {
        return this.chest.getSize();
    }

    @Override
    public int getMenuTick() {
        return 20;
    }
}

