/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.gui.models.main;

import com.mongenscave.mctreasure.data.MenuController;
import com.mongenscave.mctreasure.gui.Menu;
import com.mongenscave.mctreasure.gui.models.TreasureItemsMenu;
import com.mongenscave.mctreasure.gui.models.main.TreasureHologramMenu;
import com.mongenscave.mctreasure.gui.models.main.TreasureOverviewMenu;
import com.mongenscave.mctreasure.identifiers.ParticleTypes;
import com.mongenscave.mctreasure.identifiers.keys.ItemKeys;
import com.mongenscave.mctreasure.identifiers.keys.MenuKeys;
import com.mongenscave.mctreasure.identifiers.keys.MessageKeys;
import com.mongenscave.mctreasure.managers.TreasureManager;
import com.mongenscave.mctreasure.model.TreasureChest;
import com.mongenscave.mctreasure.sessions.ChatSessions;
import com.mongenscave.mctreasure.sessions.LocationSession;
import com.mongenscave.mctreasure.utils.PlaceholderUtils;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class TreasureEditMenu
extends Menu {
    private final TreasureChest chest;
    private final ConcurrentHashMap<Integer, ItemKeys> slotToItemKeyMap = new ConcurrentHashMap();
    private static final NamespacedKey ITEM_KEY = new NamespacedKey("mctreasure", "item_key");

    public TreasureEditMenu(@NotNull MenuController menuController, @NotNull TreasureChest chest) {
        super(menuController);
        this.chest = chest;
    }

    @Override
    public void handleMenu(@NotNull InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        event.setCancelled(true);
        ItemKeys clickedItemKey = this.slotToItemKeyMap.get(event.getSlot());
        if (clickedItemKey == null) {
            return;
        }
        switch (clickedItemKey) {
            case EDIT_NAME: {
                player.closeInventory();
                ChatSessions.setName(player, this.chest, new TreasureEditMenu(this.menuController, this.chest));
                break;
            }
            case EDIT_PERMISSION: {
                player.closeInventory();
                ChatSessions.setPermission(player, this.chest, new TreasureEditMenu(this.menuController, this.chest));
                break;
            }
            case EDIT_COOLDOWN: {
                player.closeInventory();
                ChatSessions.setCooldown(player, this.chest, new TreasureEditMenu(this.menuController, this.chest));
                break;
            }
            case EDIT_SIZE: {
                player.closeInventory();
                ChatSessions.setSize(player, this.chest, new TreasureEditMenu(this.menuController, this.chest));
                break;
            }
            case EDIT_LOCATION: {
                player.closeInventory();
                LocationSession.startSettingLocation(player, this.chest);
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.0f);
                break;
            }
            case EDIT_PUSHBACK: {
                switch (event.getClick()) {
                    case LEFT: {
                        player.closeInventory();
                        ChatSessions.setPushbackStrength(player, this.chest, new TreasureEditMenu(this.menuController, this.chest));
                        break;
                    }
                    case DROP: {
                        this.chest.setPushbackEnabled(!this.chest.isPushbackEnabled());
                        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
                        this.open();
                    }
                }
                break;
            }
            case EDIT_HOLOGRAM: {
                switch (event.getClick()) {
                    case LEFT: {
                        new TreasureHologramMenu(MenuController.getMenuUtils(player), this.chest).open();
                        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
                        break;
                    }
                    case DROP: {
                        this.chest.setHologramEnabled(!this.chest.isHologramEnabled());
                        if (this.chest.isHologramEnabled()) {
                            this.chest.setupHologram();
                        } else {
                            this.chest.removeHologram();
                        }
                        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
                        this.open();
                    }
                }
                break;
            }
            case EDIT_ITEMS: {
                new TreasureItemsMenu(MenuController.getMenuUtils(player), this.chest).open();
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
                break;
            }
            case EDIT_PARTICLE: {
                switch (event.getClick()) {
                    case LEFT: {
                        ParticleTypes currentType = this.chest.getParticleType();
                        if (currentType == null) {
                            this.chest.setParticleType(ParticleTypes.HEART);
                        } else {
                            this.chest.setParticleType(currentType.next());
                        }
                        this.chest.setParticleDisplay(TreasureManager.getInstance().getParticleFromConfig(this.chest.getParticleType()));
                        if (this.chest.isParticleEnabled()) {
                            this.chest.setupParticleEffect();
                        }
                        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
                        this.open();
                        break;
                    }
                    case RIGHT: {
                        ParticleTypes currentType = this.chest.getParticleType();
                        if (currentType == null) {
                            this.chest.setParticleType(ParticleTypes.TORNADO);
                        } else {
                            this.chest.setParticleType(currentType.previous());
                        }
                        this.chest.setParticleDisplay(TreasureManager.getInstance().getParticleFromConfig(this.chest.getParticleType()));
                        if (this.chest.isParticleEnabled()) {
                            this.chest.setupParticleEffect();
                        }
                        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
                        this.open();
                        break;
                    }
                    case DROP: {
                        this.chest.setParticleEnabled(!this.chest.isParticleEnabled());
                        if (this.chest.isParticleEnabled()) {
                            if (this.chest.getParticleType() == null) {
                                this.chest.setParticleType(ParticleTypes.HEART);
                            }
                            this.chest.setParticleDisplay(TreasureManager.getInstance().getParticleFromConfig(this.chest.getParticleType()));
                            this.chest.setupParticleEffect();
                        } else {
                            this.chest.removeParticleEffect();
                        }
                        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
                        this.open();
                    }
                }
                break;
            }
            case SAVE_ITEM: {
                TreasureManager.getInstance().saveTreasures();
                player.sendMessage(MessageKeys.SUCCESS_SAVE.getMessage());
                player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.5f, 1.0f);
                new TreasureOverviewMenu(MenuController.getMenuUtils(player)).open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.setMenuItem(ItemKeys.EDIT_NAME);
        this.setMenuItem(ItemKeys.EDIT_PERMISSION);
        this.setMenuItem(ItemKeys.EDIT_COOLDOWN);
        this.setMenuItem(ItemKeys.EDIT_SIZE);
        this.setMenuItem(ItemKeys.EDIT_LOCATION);
        this.setMenuItem(ItemKeys.EDIT_PUSHBACK);
        this.setMenuItem(ItemKeys.EDIT_HOLOGRAM);
        this.setMenuItem(ItemKeys.EDIT_PARTICLE);
        this.setMenuItem(ItemKeys.EDIT_ITEMS);
        this.setMenuItem(ItemKeys.SAVE_ITEM);
    }

    @Override
    public String getMenuName() {
        return MenuKeys.MENU_EDIT_TITLE.getString().replace("{name}", this.chest.getName());
    }

    @Override
    public int getSlots() {
        return MenuKeys.MENU_EDIT_SIZE.getInt();
    }

    @Override
    public int getMenuTick() {
        return 20;
    }

    private void setMenuItem(@NotNull ItemKeys itemKey) {
        ItemStack item = PlaceholderUtils.applyPlaceholders(itemKey.getItem(), this.chest);
        int slot = itemKey.getSlot();
        item.editMeta(meta -> meta.getPersistentDataContainer().set(ITEM_KEY, PersistentDataType.STRING, (Object)itemKey.name()));
        this.inventory.setItem(slot, item);
        this.slotToItemKeyMap.put(slot, itemKey);
    }
}

