/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.gui.models.main;

import com.mongenscave.mctreasure.data.MenuController;
import com.mongenscave.mctreasure.gui.Menu;
import com.mongenscave.mctreasure.gui.models.main.TreasureEditMenu;
import com.mongenscave.mctreasure.identifiers.keys.ItemKeys;
import com.mongenscave.mctreasure.identifiers.keys.MenuKeys;
import com.mongenscave.mctreasure.identifiers.keys.MessageKeys;
import com.mongenscave.mctreasure.managers.TreasureManager;
import com.mongenscave.mctreasure.model.TreasureChest;
import com.mongenscave.mctreasure.processor.MessageProcessor;
import com.mongenscave.mctreasure.sessions.ChatSessions;
import com.mongenscave.mctreasure.utils.PlaceholderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class TreasureHologramMenu
extends Menu {
    private final TreasureChest chest;
    private final List<String> hologramLines;
    private double hologramHeight;
    private final ConcurrentHashMap<Integer, ItemKeys> slotToItemKeyMap = new ConcurrentHashMap();
    private static final NamespacedKey ITEM_KEY = new NamespacedKey("mctreasure", "item_key");

    public TreasureHologramMenu(@NotNull MenuController menuController, @NotNull TreasureChest chest) {
        super(menuController);
        this.chest = chest;
        this.hologramLines = Collections.synchronizedList(new ArrayList<String>(chest.getHologramLines()));
        this.hologramHeight = chest.getHologramHeight();
    }

    @Override
    public void handleMenu(@NotNull InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        int slot = event.getSlot();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        event.setCancelled(true);
        ItemKeys clickedItemKey = this.slotToItemKeyMap.get(event.getSlot());
        if (clickedItemKey == null) {
            return;
        }
        switch (clickedItemKey) {
            case HOLOGRAM_SAVE: {
                this.saveHologramChanges();
                player.sendMessage(MessageKeys.SUCCESS_SAVE.getMessage());
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.0f);
                new TreasureEditMenu(MenuController.getMenuUtils(player), this.chest).open();
                return;
            }
            case HOLOGRAM_CREATE_LINE: {
                this.hologramLines.add("%blank%");
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
                this.updateHologramInRealTime();
                this.open();
                return;
            }
            case HOLOGRAM_HEIGHT_ITEM: {
                switch (event.getClick()) {
                    case LEFT: {
                        this.hologramHeight += 0.1;
                        break;
                    }
                    case RIGHT: {
                        this.hologramHeight -= 0.1;
                    }
                }
                this.updateHologramInRealTime();
                this.open();
                return;
            }
        }
        if (slot < this.hologramLines.size()) {
            switch (event.getClick()) {
                case LEFT: {
                    player.closeInventory();
                    ChatSessions.editHologramLine(player, slot, this);
                    break;
                }
                case DROP: {
                    this.hologramLines.remove(slot);
                    this.updateHologramInRealTime();
                    player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 0.5f, 1.0f);
                    this.open();
                }
            }
        }
    }

    public void updateHologramInRealTime() {
        this.chest.setHologramLines(new ArrayList<String>(this.hologramLines));
        this.chest.setHologramHeight(this.hologramHeight);
        if (this.chest.getLocation() != null) {
            this.chest.setupHologram();
        }
    }

    public void saveHologramChanges() {
        this.chest.setHologramLines(this.hologramLines);
        this.chest.setHologramHeight(this.hologramHeight);
        this.chest.setupHologram();
        TreasureManager.getInstance().saveTreasures();
    }

    @Override
    public void setMenuItems() {
        this.inventory.clear();
        for (int i = 0; i < this.hologramLines.size() && i < 52; ++i) {
            ItemStack lineItem;
            String line = this.hologramLines.get(i);
            if ("%blank%".equals(line)) {
                lineItem = ItemKeys.HOLOGRAM_BLANK_ITEM.getItem();
            } else {
                lineItem = ItemKeys.HOLOGRAM_LINE_ITEM.getItem();
                ItemMeta meta = lineItem.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName(MessageProcessor.process(meta.getDisplayName().replace("{content}", line)));
                    lineItem.setItemMeta(meta);
                }
            }
            this.inventory.setItem(i, lineItem);
        }
        this.setMenuItemWithPlaceholders();
        this.setMenuItem(ItemKeys.HOLOGRAM_CREATE_LINE);
        this.setMenuItem(ItemKeys.HOLOGRAM_SAVE);
    }

    @Override
    public String getMenuName() {
        return MenuKeys.MENU_EDIT_HOLOGRAM_TITLE.getString();
    }

    @Override
    public int getSlots() {
        return MenuKeys.MENU_EDIT_HOLOGRAM_SIZE.getInt();
    }

    @Override
    public int getMenuTick() {
        return 20;
    }

    private void setMenuItem(@NotNull ItemKeys itemKey) {
        ItemStack item = PlaceholderUtils.applyPlaceholders(itemKey.getItem(), this.chest);
        int slot = itemKey.getSlot();
        item.editMeta(meta -> meta.getPersistentDataContainer().set(ITEM_KEY, PersistentDataType.STRING, (Object)itemKey.name()));
        this.inventory.setItem(slot, item);
        this.slotToItemKeyMap.put(slot, itemKey);
    }

    private void setMenuItemWithPlaceholders() {
        ItemStack item = PlaceholderUtils.applyPlaceholders(ItemKeys.HOLOGRAM_HEIGHT_ITEM.getItem(), this.chest);
        int slot = ItemKeys.HOLOGRAM_HEIGHT_ITEM.getSlot();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            List lore;
            if (meta.hasDisplayName()) {
                String displayName = meta.getDisplayName();
                displayName = displayName.replace("{height-status}", String.format("%.1f", this.hologramHeight));
                meta.setDisplayName(displayName);
            }
            if (meta.hasLore() && (lore = meta.getLore()) != null) {
                for (int i = 0; i < lore.size(); ++i) {
                    String line = (String)lore.get(i);
                    if (!line.contains("{height-status}")) continue;
                    line = line.replace("{height-status}", String.format("%.1f", this.hologramHeight));
                    lore.set(i, line);
                }
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
        item.editMeta(itemMeta -> itemMeta.getPersistentDataContainer().set(ITEM_KEY, PersistentDataType.STRING, (Object)ItemKeys.HOLOGRAM_HEIGHT_ITEM.name()));
        this.inventory.setItem(slot, item);
        this.slotToItemKeyMap.put(slot, ItemKeys.HOLOGRAM_HEIGHT_ITEM);
    }

    @Generated
    public List<String> getHologramLines() {
        return this.hologramLines;
    }
}

