/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.gui.models.main;

import com.mongenscave.mctreasure.data.MenuController;
import com.mongenscave.mctreasure.gui.Menu;
import com.mongenscave.mctreasure.gui.models.TreasurePreviewMenu;
import com.mongenscave.mctreasure.gui.models.main.TreasureEditMenu;
import com.mongenscave.mctreasure.identifiers.keys.ItemKeys;
import com.mongenscave.mctreasure.identifiers.keys.MenuKeys;
import com.mongenscave.mctreasure.managers.TreasureManager;
import com.mongenscave.mctreasure.model.TreasureChest;
import com.mongenscave.mctreasure.processor.MessageProcessor;
import com.mongenscave.mctreasure.utils.PlaceholderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class TreasureOverviewMenu
extends Menu {
    private final TreasureManager treasureManager = TreasureManager.getInstance();
    private final List<TreasureChest> treasureChests = this.treasureManager.getAllTreasures();

    public TreasureOverviewMenu(@NotNull MenuController menuController) {
        super(menuController);
    }

    @Override
    public void handleMenu(@NotNull InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        event.setCancelled(true);
        if (event.getSlot() == ItemKeys.OVERVIEW_CREATE_TREASURE.getSlot()) {
            if (event.getClick() == ClickType.LEFT) {
                String id = "treasure_" + UUID.randomUUID().toString().substring(0, 8);
                TreasureChest treasure = this.treasureManager.createTreasure(id);
                this.treasureManager.saveTreasures();
                new TreasureEditMenu(MenuController.getMenuUtils(player), treasure).open();
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
            }
            return;
        }
        int index = event.getSlot();
        if (index >= 0 && index < this.treasureChests.size()) {
            TreasureChest treasure = this.treasureChests.get(index);
            switch (event.getClick()) {
                case LEFT: {
                    new TreasureEditMenu(MenuController.getMenuUtils(player), treasure).open();
                    player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
                    break;
                }
                case RIGHT: {
                    new TreasurePreviewMenu(MenuController.getMenuUtils(player), treasure).open();
                    player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
                    break;
                }
                case DROP: {
                    player.closeInventory();
                    this.treasureManager.deleteTreasure(treasure.getId());
                    player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 0.5f, 0.5f);
                    new TreasureOverviewMenu(MenuController.getMenuUtils(player)).open();
                }
            }
        }
    }

    @Override
    public void setMenuItems() {
        AtomicInteger slot = new AtomicInteger(0);
        this.treasureChests.forEach(treasure -> {
            int currentSlot = slot.getAndIncrement();
            if (currentSlot < 53) {
                this.inventory.setItem(currentSlot, this.createTreasureItem((TreasureChest)treasure));
            }
        });
        this.inventory.setItem(ItemKeys.OVERVIEW_CREATE_TREASURE.getSlot(), ItemKeys.OVERVIEW_CREATE_TREASURE.getItem());
    }

    @Override
    public String getMenuName() {
        return MenuKeys.MENU_OVERVIEW_TITLE.getString();
    }

    @Override
    public int getSlots() {
        return MenuKeys.MENU_OVERVIEW_SIZE.getInt();
    }

    @Override
    public int getMenuTick() {
        return 20;
    }

    @NotNull
    private ItemStack createTreasureItem(@NotNull TreasureChest treasure) {
        ItemStack baseItem = ItemKeys.OVERVIEW_TREASURE_ITEM.getItem();
        if (baseItem == null) {
            baseItem = new ItemStack(Material.BARREL);
            ItemMeta meta = baseItem.getItemMeta();
            meta.setDisplayName(MessageProcessor.process(treasure.getName()));
            baseItem.setItemMeta(meta);
            return baseItem;
        }
        ItemStack result = baseItem.clone();
        ItemMeta meta = result.getItemMeta();
        if (meta.hasDisplayName()) {
            String name = meta.getDisplayName().replace("{name}", treasure.getName());
            meta.setDisplayName(MessageProcessor.process(name));
        }
        if (meta.hasLore() && meta.getLore() != null) {
            ArrayList<String> lore = new ArrayList<String>();
            List originalLore = meta.getLore();
            for (String line : originalLore) {
                line = PlaceholderUtils.replacePlaceholders(line, treasure);
                lore.add(MessageProcessor.process(line));
            }
            meta.setLore(lore);
        }
        result.setItemMeta(meta);
        return result;
    }
}

