/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.item;

import com.mongenscave.mctreasure.item.ItemFactory;
import com.mongenscave.mctreasure.processor.MessageProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class ItemBuilder
implements ItemFactory {
    private final ItemStack is;
    private final ItemMeta meta;
    private int slot;
    private boolean finished = false;

    public ItemBuilder(@NotNull ItemStack item) {
        this.is = item;
        this.meta = item.getItemMeta();
    }

    ItemBuilder(@NotNull Material type) {
        this(type, 1);
    }

    public ItemBuilder(@NotNull Material type, @Range(from=0L, to=64L) int amount) {
        this(type, amount, 0);
    }

    public ItemBuilder(@NotNull Material type, @Range(from=0L, to=64L) int amount, short damage) {
        this(type, amount, damage, null);
    }

    public ItemBuilder(@NotNull Material type, @Range(from=0L, to=64L) int amount, short damage, @Nullable Byte data) {
        this.is = new ItemStack(type, amount, damage, data);
        this.meta = this.is.getItemMeta();
    }

    @Override
    public ItemBuilder setType(@NotNull Material material) {
        this.is.setType(material);
        return this;
    }

    @Override
    public ItemBuilder setCount(@Range(from=0L, to=64L) int newCount) {
        this.is.setAmount(newCount);
        return this;
    }

    @Override
    public ItemBuilder setName(@NotNull String name) {
        this.meta.setDisplayName(MessageProcessor.process(name));
        return this;
    }

    @Override
    public ItemBuilder setLore(@NotNull List<String> lore) {
        this.meta.setLore(lore);
        return this;
    }

    @Override
    public void addEnchantment(@NotNull Enchantment enchantment, int level) {
        this.meta.addEnchant(enchantment, level, true);
    }

    @Override
    public ItemBuilder addLore(String ... lores) {
        List<String> loreList = Arrays.asList(lores);
        List<String> currentLores = this.meta.getLore();
        currentLores = currentLores == null ? Collections.synchronizedList(new ArrayList()) : currentLores;
        currentLores.addAll(loreList);
        this.meta.setLore(currentLores);
        return this;
    }

    @Override
    public ItemBuilder setUnbreakable() {
        this.meta.setUnbreakable(true);
        return this;
    }

    public ItemBuilder addFlag(@NotNull ItemFlag flag) {
        this.meta.addItemFlags(new ItemFlag[]{flag});
        return this;
    }

    @Override
    public ItemBuilder removeLore(int line) {
        List lores = this.meta.getLore();
        lores = lores == null ? Collections.synchronizedList(new ArrayList()) : lores;
        lores.remove(Math.min(line, lores.size()));
        this.meta.setLore(lores);
        return this;
    }

    @Override
    public ItemStack finish() {
        this.is.setItemMeta(this.meta);
        this.finished = true;
        return this.is;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }
}

