/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.item;

import com.mongenscave.mctreasure.McTreasure;
import com.mongenscave.mctreasure.boostedyaml.block.implementation.Section;
import com.mongenscave.mctreasure.config.Config;
import com.mongenscave.mctreasure.item.ItemBuilder;
import com.mongenscave.mctreasure.processor.MessageProcessor;
import com.mongenscave.mctreasure.utils.LoggerUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ItemFactory {
    @Contract(value="_ -> new")
    @NotNull
    public static ItemFactory create(@NotNull Material material) {
        return new ItemBuilder(material);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static ItemFactory create(@NotNull Material material, int count) {
        return new ItemBuilder(material, count);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static ItemFactory create(@NotNull Material material, int count, short damage) {
        return new ItemBuilder(material, count, damage);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ItemFactory create(ItemStack item) {
        return new ItemBuilder(item);
    }

    public static Optional<ItemStack> buildItem(@NotNull Section section, @NotNull String configPath) {
        try {
            Material material;
            String materialName = section.getString("material");
            if (materialName == null || materialName.isEmpty()) {
                return Optional.empty();
            }
            try {
                material = Material.valueOf((String)materialName.toUpperCase());
            }
            catch (IllegalArgumentException exception) {
                return Optional.empty();
            }
            int amount = section.getInt("amount", Integer.valueOf(1));
            amount = Math.max(1, Math.min(amount, 64));
            String rawName = section.getString("name", "");
            String processedName = rawName.isEmpty() ? "" : MessageProcessor.process(rawName);
            List<String> lore = section.getStringList("lore").stream().map(MessageProcessor::process).toList();
            ItemStack item = ItemFactory.create(material, amount).setName(processedName).addLore(lore.toArray(new String[0])).finish();
            List enchantmentStrings = section.getStringList("enchantments");
            for (String enchantmentString : enchantmentStrings) {
                String[] parts = enchantmentString.split(":");
                if (parts.length != 2) continue;
                try {
                    Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)parts[0].toLowerCase()));
                    if (enchantment == null) continue;
                    int level = Integer.parseInt(parts[1]);
                    item.addUnsafeEnchantment(enchantment, level);
                }
                catch (Exception exception) {}
            }
            boolean unbreakable = section.getBoolean("unbreakable", Boolean.valueOf(false));
            if (unbreakable) {
                item.editMeta(meta -> meta.setUnbreakable(true));
            }
            item.editMeta(meta -> {
                PersistentDataContainer pdc = meta.getPersistentDataContainer();
                NamespacedKey key = new NamespacedKey((Plugin)McTreasure.getInstance(), "mcTreasure");
                pdc.set(key, PersistentDataType.STRING, (Object)configPath);
            });
            return Optional.of(item);
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static Optional<ItemStack> createItemFromString(@NotNull String path, @NotNull Config config) {
        Section section = config.getSection(path);
        return section != null ? ItemFactory.buildItem(section, path) : Optional.empty();
    }

    public static void serializeItem(@NotNull ItemStack item, @NotNull Config config, @NotNull String configPath) {
        try {
            if (item.getType() == Material.AIR) {
                LoggerUtils.warn("Trying to serialize null or AIR item at path: " + configPath, new Object[0]);
                return;
            }
            LoggerUtils.info("Serializing item at path: " + configPath + ", type: " + item.getType().name(), new Object[0]);
            config.set(configPath, null);
            config.set(configPath + ".material", item.getType().name());
            config.set(configPath + ".amount", item.getAmount());
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                if (meta.hasDisplayName()) {
                    config.set(configPath + ".name", meta.getDisplayName());
                } else {
                    config.set(configPath + ".name", "");
                }
                if (meta.hasLore() && meta.getLore() != null) {
                    config.set(configPath + ".lore", meta.getLore());
                } else {
                    config.set(configPath + ".lore", new ArrayList());
                }
                config.set(configPath + ".unbreakable", meta.isUnbreakable());
                ArrayList<CallSite> enchantments = new ArrayList<CallSite>();
                for (Map.Entry entry : item.getEnchantments().entrySet()) {
                    Enchantment enchantment = (Enchantment)entry.getKey();
                    NamespacedKey key = enchantment.getKey();
                    enchantments.add((CallSite)((Object)(key.getKey() + ":" + String.valueOf(entry.getValue()))));
                }
                config.set(configPath + ".enchantments", enchantments);
                if (!meta.getItemFlags().isEmpty()) {
                    List<String> flags = Collections.synchronizedList(new ArrayList());
                    for (ItemFlag flag : meta.getItemFlags()) {
                        flags.add(flag.name());
                    }
                    config.set(configPath + ".item_flags", flags);
                } else {
                    config.set(configPath + ".item_flags", new ArrayList());
                }
            }
        }
        catch (Exception exception) {
            LoggerUtils.error("Failed to serialize item at path " + configPath + ": " + exception.getMessage(), new Object[0]);
        }
    }

    public static String getPathFromItem(@Nullable ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        PersistentDataContainer container = item.getItemMeta().getPersistentDataContainer();
        NamespacedKey key = new NamespacedKey((Plugin)McTreasure.getInstance(), "mcTreasure");
        return (String)container.get(key, PersistentDataType.STRING);
    }

    public ItemFactory setType(@NotNull Material var1);

    public ItemFactory setCount(int var1);

    public ItemFactory setName(@NotNull String var1);

    public ItemBuilder setLore(@NotNull List<String> var1);

    public void addEnchantment(@NotNull Enchantment var1, int var2);

    default public ItemFactory addEnchantments(@NotNull ConcurrentHashMap<Enchantment, Integer> enchantments) {
        enchantments.forEach(this::addEnchantment);
        return this;
    }

    public ItemBuilder addLore(String ... var1);

    public ItemFactory setUnbreakable();

    default public void addFlag(ItemFlag ... flags) {
        Arrays.stream(flags).forEach(xva$0 -> this.addFlag((ItemFlag)xva$0));
    }

    public ItemFactory removeLore(int var1);

    public ItemStack finish();

    public boolean isFinished();
}

