/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.managers;

import com.mongenscave.mctreasure.data.CooldownResult;
import com.mongenscave.mctreasure.utils.TimeUtils;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class CooldownManager {
    private static CooldownManager instance;
    private final ConcurrentHashMap<String, ConcurrentHashMap<UUID, Long>> cooldownData = new ConcurrentHashMap();

    private CooldownManager() {
    }

    public static CooldownManager getInstance() {
        if (instance == null) {
            instance = new CooldownManager();
        }
        return instance;
    }

    @NotNull
    public CooldownResult checkCooldown(@NotNull String treasureId, @NotNull UUID playerId, long cooldownMillis) {
        if (cooldownMillis <= 0L) {
            return new CooldownResult(true, null, 0L);
        }
        ConcurrentHashMap<UUID, Long> treasureCooldowns = this.cooldownData.get(treasureId);
        if (treasureCooldowns == null) {
            return new CooldownResult(true, null, 0L);
        }
        Long lastOpened = treasureCooldowns.get(playerId);
        if (lastOpened == null || lastOpened == 0L) {
            return new CooldownResult(true, null, 0L);
        }
        long currentTime = System.currentTimeMillis();
        long remainingTime = lastOpened + cooldownMillis - currentTime;
        if (remainingTime <= 0L) {
            return new CooldownResult(true, null, 0L);
        }
        String formattedTime = TimeUtils.formatTime(remainingTime);
        return new CooldownResult(false, formattedTime, remainingTime);
    }

    public void recordOpen(@NotNull String treasureId, @NotNull UUID playerId) {
        this.cooldownData.computeIfAbsent(treasureId, k -> new ConcurrentHashMap()).put(playerId, System.currentTimeMillis());
    }

    public void removeTreasure(@NotNull String treasureId) {
        this.cooldownData.remove(treasureId);
    }

    public void initializeTreasure(@NotNull String treasureId) {
        this.cooldownData.computeIfAbsent(treasureId, k -> new ConcurrentHashMap());
    }

    public long getShortestRemainingCooldown(@NotNull String treasureId, long cooldownMillis) {
        if (cooldownMillis <= 0L) {
            return 0L;
        }
        ConcurrentHashMap<UUID, Long> treasureCooldowns = this.cooldownData.get(treasureId);
        if (treasureCooldowns == null || treasureCooldowns.isEmpty()) {
            return 0L;
        }
        long currentTime = System.currentTimeMillis();
        long shortestRemaining = Long.MAX_VALUE;
        boolean hasActiveCooldown = false;
        for (Long lastOpened : treasureCooldowns.values()) {
            long remainingTime;
            if (lastOpened == null || lastOpened <= 0L || (remainingTime = lastOpened + cooldownMillis - currentTime) <= 0L) continue;
            hasActiveCooldown = true;
            shortestRemaining = Math.min(shortestRemaining, remainingTime);
        }
        return hasActiveCooldown ? shortestRemaining : 0L;
    }

    public void clearAll() {
        this.cooldownData.clear();
    }
}

