/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.managers;

import com.mongenscave.mctreasure.McTreasure;
import com.mongenscave.mctreasure.boostedyaml.block.implementation.Section;
import com.mongenscave.mctreasure.config.Config;
import com.mongenscave.mctreasure.identifiers.ParticleTypes;
import com.mongenscave.mctreasure.item.ItemFactory;
import com.mongenscave.mctreasure.managers.CooldownManager;
import com.mongenscave.mctreasure.model.TreasureChest;
import com.mongenscave.mctreasure.utils.LocationUtils;
import com.mongenscave.mctreasure.utils.LoggerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreasureManager {
    private static final McTreasure plugin = McTreasure.getInstance();
    private static TreasureManager instance;
    private final ConcurrentHashMap<String, TreasureChest> treasureChests = new ConcurrentHashMap();

    private TreasureManager() {
        this.loadTreasures();
    }

    public static TreasureManager getInstance() {
        if (instance == null) {
            instance = new TreasureManager();
        }
        return instance;
    }

    public TreasureChest createTreasure(@NotNull String id) {
        TreasureChest chest = TreasureChest.builder().id(id).name("&6&lTreasure Chest").pushbackEnabled(true).pushbackStrength(1.0).hologramEnabled(false).hologramLines(Collections.synchronizedList(new ArrayList<String>(List.of("&6&lTreasure Chest", "{time-left}")))).cooldownMillis(0L).permission("").size(27).items(Collections.synchronizedList(new ArrayList())).particleEnabled(false).particleType(ParticleTypes.HELIX).particleDisplay(this.getParticleFromConfig(ParticleTypes.HELIX)).build();
        this.treasureChests.put(id, chest);
        CooldownManager.getInstance().initializeTreasure(id);
        return chest;
    }

    @Nullable
    public TreasureChest getTreasure(@NotNull String id) {
        return this.treasureChests.get(id);
    }

    @NotNull
    public List<TreasureChest> getAllTreasures() {
        return new ArrayList<TreasureChest>(this.treasureChests.values());
    }

    public boolean deleteTreasure(@NotNull String id) {
        TreasureChest chest = this.treasureChests.remove(id);
        if (chest != null) {
            chest.removeHologram();
            chest.removeParticleEffect();
            CooldownManager.getInstance().removeTreasure(id);
            this.saveTreasures();
            return true;
        }
        return false;
    }

    public Particle getParticleFromConfig(@NotNull ParticleTypes type) {
        Config config = plugin.getConfiguration();
        String particleName = config.getString("effect-particles." + type.name().toLowerCase(), "FLAME");
        try {
            return Particle.valueOf((String)particleName.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            LoggerUtils.warn("Invalid particle type in config: " + particleName + ", using FLAME as default", new Object[0]);
            return Particle.FLAME;
        }
    }

    public void loadTreasures() {
        Config treasuresConfig = plugin.getTreasures();
        this.treasureChests.values().forEach(chest -> {
            chest.removeHologram();
            chest.removeParticleEffect();
        });
        this.treasureChests.clear();
        CooldownManager.getInstance().clearAll();
        Section treasuresSection = treasuresConfig.getSection("treasures");
        if (treasuresSection == null) {
            return;
        }
        for (String id : treasuresSection.getRoutesAsStrings(false)) {
            try {
                ParticleTypes particleType;
                Section chestSection = treasuresConfig.getSection("treasures." + id);
                if (chestSection == null) continue;
                String name = chestSection.getString("name", "&6&lTreasure Chest");
                String locationStr = chestSection.getString("location");
                Location location = locationStr != null ? LocationUtils.deserialize(locationStr) : null;
                boolean pushbackEnabled = chestSection.getBoolean("pushback.enabled", Boolean.valueOf(true));
                double pushbackStrength = chestSection.getDouble("pushback.strength", Double.valueOf(1.0));
                boolean hologramEnabled = chestSection.getBoolean("hologram.enabled", Boolean.valueOf(true));
                List<String> hologramLines = chestSection.getStringList("hologram.lines");
                if (hologramLines.isEmpty()) {
                    hologramLines = Collections.synchronizedList(new ArrayList<String>(List.of("&6&lTreasure Chest", "&7Open me!")));
                }
                long cooldownMillis = chestSection.getLong("cooldown", Long.valueOf(3600000L));
                String permission = chestSection.getString("permission", "");
                int size = chestSection.getInt("size", Integer.valueOf(27));
                boolean particleEnabled = chestSection.getBoolean("particle.enabled", Boolean.valueOf(false));
                String particleTypeName = chestSection.getString("particle.type", "HELIX");
                try {
                    particleType = ParticleTypes.valueOf(particleTypeName.toUpperCase());
                }
                catch (IllegalArgumentException exception) {
                    particleType = ParticleTypes.HELIX;
                }
                List<ItemStack> items = Collections.synchronizedList(new ArrayList());
                Section itemsSection = chestSection.getSection("items");
                if (itemsSection != null) {
                    for (String itemKey : itemsSection.getRoutesAsStrings(false)) {
                        Section itemSection = itemsSection.getSection(itemKey);
                        if (itemSection == null) continue;
                        ItemFactory.buildItem(itemSection, "treasures." + id + ".items." + itemKey).ifPresent(items::add);
                    }
                }
                TreasureChest chest2 = TreasureChest.builder().id(id).name(name).location(location).pushbackEnabled(pushbackEnabled).pushbackStrength(pushbackStrength).hologramEnabled(hologramEnabled).hologramLines(hologramLines).cooldownMillis(cooldownMillis).permission(permission).size(size).items(items).particleEnabled(particleEnabled).particleDisplay(this.getParticleFromConfig(particleType)).particleType(particleType).build();
                this.treasureChests.put(id, chest2);
                CooldownManager.getInstance().initializeTreasure(id);
                if (location == null) continue;
                if (hologramEnabled) {
                    chest2.setupHologram();
                }
                if (!particleEnabled) continue;
                chest2.setupParticleEffect();
            }
            catch (Exception exception) {
                LoggerUtils.error("Failed to load treasure chest with ID: " + id, new Object[0]);
                exception.printStackTrace();
            }
        }
        LoggerUtils.info("Loaded " + this.treasureChests.size() + " treasure chests.", new Object[0]);
    }

    public void saveTreasures() {
        try {
            Config treasuresConfig = plugin.getTreasures();
            treasuresConfig.set("treasures", null);
            for (Map.Entry<String, TreasureChest> entry : this.treasureChests.entrySet()) {
                String id = entry.getKey();
                TreasureChest chest = entry.getValue();
                treasuresConfig.set("treasures." + id + ".name", chest.getName());
                if (chest.getLocation() != null) {
                    treasuresConfig.set("treasures." + id + ".location", LocationUtils.serialize(chest.getLocation()));
                }
                treasuresConfig.set("treasures." + id + ".pushback.enabled", chest.isPushbackEnabled());
                treasuresConfig.set("treasures." + id + ".pushback.strength", chest.getPushbackStrength());
                treasuresConfig.set("treasures." + id + ".hologram.enabled", chest.isHologramEnabled());
                treasuresConfig.set("treasures." + id + ".hologram.lines", chest.getHologramLines());
                treasuresConfig.set("treasures." + id + ".cooldown", chest.getCooldownMillis());
                treasuresConfig.set("treasures." + id + ".permission", chest.getPermission());
                treasuresConfig.set("treasures." + id + ".size", chest.getSize());
                treasuresConfig.set("treasures." + id + ".particle.enabled", chest.isParticleEnabled());
                treasuresConfig.set("treasures." + id + ".particle.type", chest.getParticleType().name());
                treasuresConfig.set("treasures." + id + ".items", null);
                List<ItemStack> items = chest.getItems();
                if (items == null || items.isEmpty()) continue;
                treasuresConfig.set("treasures." + id + ".items", new HashMap());
                int validItemCount = 0;
                for (int i = 0; i < items.size(); ++i) {
                    ItemStack item = items.get(i);
                    if (item == null || item.getType() == Material.AIR) continue;
                    ++validItemCount;
                    String itemPath = "treasures." + id + ".items." + i;
                    ItemFactory.serializeItem(item, treasuresConfig, itemPath);
                }
            }
            treasuresConfig.save();
            LoggerUtils.info("Saved all treasure chests to configuration.", new Object[0]);
        }
        catch (Exception exception) {
            LoggerUtils.error("Error saving treasures: " + exception.getMessage(), new Object[0]);
        }
    }

    public void applyPushback(@NotNull Player player, @NotNull TreasureChest chest) {
        if (!chest.isPushbackEnabled() || chest.getLocation() == null) {
            return;
        }
        Location chestLoc = chest.getLocation();
        Location playerLoc = player.getLocation();
        Vector direction = playerLoc.toVector().subtract(chestLoc.toVector()).normalize();
        direction.multiply(chest.getPushbackStrength());
        direction.setY(0.3);
        player.setVelocity(direction);
    }

    @Nullable
    public TreasureChest getChestAtLocation(@NotNull Location location) {
        for (TreasureChest chest : this.treasureChests.values()) {
            if (chest.getLocation() == null || !chest.getLocation().equals((Object)location)) continue;
            return chest;
        }
        return null;
    }
}

