/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.model;

import com.mongenscave.mctreasure.McTreasure;
import com.mongenscave.mctreasure.data.CooldownResult;
import com.mongenscave.mctreasure.data.OpenResult;
import com.mongenscave.mctreasure.data.ParticleEffectConfiguration;
import com.mongenscave.mctreasure.identifiers.ParticleTypes;
import com.mongenscave.mctreasure.identifiers.keys.MessageKeys;
import com.mongenscave.mctreasure.managers.CooldownManager;
import com.mongenscave.mctreasure.managers.TreasureManager;
import com.mongenscave.mctreasure.particles.ParticleSystem;
import com.mongenscave.mctreasure.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.mongenscave.mctreasure.utils.TimeUtils;
import eu.decentsoftware.holograms.api.DHAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TreasureChest {
    private final String id;
    private String name;
    private Location location;
    private boolean pushbackEnabled;
    private double pushbackStrength;
    private boolean hologramEnabled;
    private List<String> hologramLines;
    private double hologramHeight;
    private long cooldownMillis;
    private String permission;
    private int size;
    private List<ItemStack> items;
    private ParticleTypes particleType;
    private Particle particleDisplay;
    private boolean particleEnabled;
    private transient UUID particleEffectId;
    private transient String hologramId;
    private transient MyScheduledTask hologramUpdateTask;

    public void setupHologram() {
        if (!this.hologramEnabled || this.location == null || this.hologramLines == null || this.hologramLines.isEmpty()) {
            this.removeHologram();
            return;
        }
        Location holoLoc = this.location.clone().add(0.5, 1.5 + this.hologramHeight, 0.5);
        if (this.hologramId != null) {
            DHAPI.removeHologram((String)this.hologramId);
        }
        List<String> processedLines = this.processHologramLines();
        this.hologramId = "treasure-" + this.id;
        DHAPI.createHologram((String)this.hologramId, (Location)holoLoc, processedLines);
        if (this.hasTimeLeftPlaceholder()) {
            this.startHologramUpdateTask();
        }
    }

    public void removeHologram() {
        if (this.hologramId != null) {
            DHAPI.removeHologram((String)this.hologramId);
            this.hologramId = null;
        }
        this.stopHologramUpdateTask();
    }

    public void setupParticleEffect() {
        if (!this.particleEnabled || this.location == null) {
            this.removeParticleEffect();
            return;
        }
        if (this.particleEffectId != null) {
            this.removeParticleEffect();
        }
        this.particleDisplay = TreasureManager.getInstance().getParticleFromConfig(this.particleType);
        ParticleEffectConfiguration config = this.createParticleConfig();
        this.particleEffectId = ParticleSystem.getInstance().startEffect(this.particleType, config);
    }

    public void removeParticleEffect() {
        if (this.particleEffectId != null) {
            ParticleSystem.getInstance().stopEffect(this.particleEffectId);
            this.particleEffectId = null;
        }
    }

    public void refreshParticleEffect() {
        this.removeParticleEffect();
        if (this.particleEnabled) {
            this.setupParticleEffect();
        }
    }

    @NotNull
    public OpenResult canPlayerOpen(@NotNull Player player) {
        CooldownResult result = CooldownManager.getInstance().checkCooldown(this.id, player.getUniqueId(), this.cooldownMillis);
        if (result.canOpen()) {
            return new OpenResult(true, null);
        }
        String message = null;
        if (result.formattedTime() != null) {
            message = MessageKeys.COOLDOWN.getMessage().replace("{time}", result.formattedTime());
        }
        return new OpenResult(false, message);
    }

    public void recordPlayerOpen(@NotNull Player player) {
        CooldownManager.getInstance().recordOpen(this.id, player.getUniqueId());
    }

    public void cleanup() {
        this.removeHologram();
        this.removeParticleEffect();
    }

    private boolean hasTimeLeftPlaceholder() {
        return this.hologramLines.stream().anyMatch(line -> line.contains("{time-left}"));
    }

    private void startHologramUpdateTask() {
        this.stopHologramUpdateTask();
        if (this.hasTimeLeftPlaceholder()) {
            this.hologramUpdateTask = McTreasure.getInstance().getScheduler().runTaskTimerAsynchronously(() -> {
                if (this.hologramEnabled && this.hologramId != null) {
                    this.setupHologram();
                }
            }, 20L, 20L);
        }
    }

    private void stopHologramUpdateTask() {
        if (this.hologramUpdateTask != null && !this.hologramUpdateTask.isCancelled()) {
            this.hologramUpdateTask.cancel();
            this.hologramUpdateTask = null;
        }
    }

    @NotNull
    private ParticleEffectConfiguration createParticleConfig() {
        ParticleEffectConfiguration config = ParticleEffectConfiguration.at(this.location.clone().add(0.5, 0.5, 0.5));
        config.setParticleType(this.particleDisplay != null ? this.particleDisplay : Particle.FLAME);
        config.setDuration(0);
        return config;
    }

    @NotNull
    private List<String> processHologramLines() {
        List<String> processedLines = Collections.synchronizedList(new ArrayList());
        for (String line : this.hologramLines) {
            if (line.equals("%blank%")) {
                processedLines.add("");
                continue;
            }
            String processedLine = line;
            if (processedLine.contains("{time-left}")) {
                processedLine = processedLine.replace("{time-left}", this.getTimeLeftDisplay());
            }
            processedLines.add(processedLine);
        }
        return processedLines;
    }

    private String getTimeLeftDisplay() {
        if (this.cooldownMillis <= 0L) {
            return McTreasure.getInstance().getConfiguration().getString("placeholders.hologram.ready", "&a&lREADY TO OPEN&7!");
        }
        long remainingTime = CooldownManager.getInstance().getShortestRemainingCooldown(this.id, this.cooldownMillis);
        if (remainingTime <= 0L) {
            return McTreasure.getInstance().getConfiguration().getString("placeholders.hologram.ready", "&a&lREADY TO OPEN&7!");
        }
        String formattedTime = TimeUtils.formatTime(remainingTime);
        String timeLeftFormat = McTreasure.getInstance().getConfiguration().getString("placeholders.hologram.time-left", "&c%s");
        return String.format(timeLeftFormat, formattedTime);
    }

    @Generated
    TreasureChest(String id, String name, Location location, boolean pushbackEnabled, double pushbackStrength, boolean hologramEnabled, List<String> hologramLines, double hologramHeight, long cooldownMillis, String permission, int size, List<ItemStack> items, ParticleTypes particleType, Particle particleDisplay, boolean particleEnabled, UUID particleEffectId, String hologramId, MyScheduledTask hologramUpdateTask) {
        this.id = id;
        this.name = name;
        this.location = location;
        this.pushbackEnabled = pushbackEnabled;
        this.pushbackStrength = pushbackStrength;
        this.hologramEnabled = hologramEnabled;
        this.hologramLines = hologramLines;
        this.hologramHeight = hologramHeight;
        this.cooldownMillis = cooldownMillis;
        this.permission = permission;
        this.size = size;
        this.items = items;
        this.particleType = particleType;
        this.particleDisplay = particleDisplay;
        this.particleEnabled = particleEnabled;
        this.particleEffectId = particleEffectId;
        this.hologramId = hologramId;
        this.hologramUpdateTask = hologramUpdateTask;
    }

    @Generated
    public static TreasureChestBuilder builder() {
        return new TreasureChestBuilder();
    }

    @Generated
    public UUID getParticleEffectId() {
        return this.particleEffectId;
    }

    @Generated
    public String getHologramId() {
        return this.hologramId;
    }

    @Generated
    public MyScheduledTask getHologramUpdateTask() {
        return this.hologramUpdateTask;
    }

    @Generated
    public void setParticleEffectId(UUID particleEffectId) {
        this.particleEffectId = particleEffectId;
    }

    @Generated
    public void setHologramId(String hologramId) {
        this.hologramId = hologramId;
    }

    @Generated
    public void setHologramUpdateTask(MyScheduledTask hologramUpdateTask) {
        this.hologramUpdateTask = hologramUpdateTask;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreasureChest)) {
            return false;
        }
        TreasureChest other = (TreasureChest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPushbackEnabled() != other.isPushbackEnabled()) {
            return false;
        }
        if (Double.compare(this.getPushbackStrength(), other.getPushbackStrength()) != 0) {
            return false;
        }
        if (this.isHologramEnabled() != other.isHologramEnabled()) {
            return false;
        }
        if (Double.compare(this.getHologramHeight(), other.getHologramHeight()) != 0) {
            return false;
        }
        if (this.getCooldownMillis() != other.getCooldownMillis()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.isParticleEnabled() != other.isParticleEnabled()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        List<String> this$hologramLines = this.getHologramLines();
        List<String> other$hologramLines = other.getHologramLines();
        if (this$hologramLines == null ? other$hologramLines != null : !((Object)this$hologramLines).equals(other$hologramLines)) {
            return false;
        }
        String this$permission = this.getPermission();
        String other$permission = other.getPermission();
        if (this$permission == null ? other$permission != null : !this$permission.equals(other$permission)) {
            return false;
        }
        List<ItemStack> this$items = this.getItems();
        List<ItemStack> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        ParticleTypes this$particleType = this.getParticleType();
        ParticleTypes other$particleType = other.getParticleType();
        if (this$particleType == null ? other$particleType != null : !((Object)((Object)this$particleType)).equals((Object)other$particleType)) {
            return false;
        }
        Particle this$particleDisplay = this.getParticleDisplay();
        Particle other$particleDisplay = other.getParticleDisplay();
        return !(this$particleDisplay == null ? other$particleDisplay != null : !this$particleDisplay.equals(other$particleDisplay));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TreasureChest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPushbackEnabled() ? 79 : 97);
        long $pushbackStrength = Double.doubleToLongBits(this.getPushbackStrength());
        result = result * 59 + (int)($pushbackStrength >>> 32 ^ $pushbackStrength);
        result = result * 59 + (this.isHologramEnabled() ? 79 : 97);
        long $hologramHeight = Double.doubleToLongBits(this.getHologramHeight());
        result = result * 59 + (int)($hologramHeight >>> 32 ^ $hologramHeight);
        long $cooldownMillis = this.getCooldownMillis();
        result = result * 59 + (int)($cooldownMillis >>> 32 ^ $cooldownMillis);
        result = result * 59 + this.getSize();
        result = result * 59 + (this.isParticleEnabled() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        List<String> $hologramLines = this.getHologramLines();
        result = result * 59 + ($hologramLines == null ? 43 : ((Object)$hologramLines).hashCode());
        String $permission = this.getPermission();
        result = result * 59 + ($permission == null ? 43 : $permission.hashCode());
        List<ItemStack> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        ParticleTypes $particleType = this.getParticleType();
        result = result * 59 + ($particleType == null ? 43 : ((Object)((Object)$particleType)).hashCode());
        Particle $particleDisplay = this.getParticleDisplay();
        result = result * 59 + ($particleDisplay == null ? 43 : $particleDisplay.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TreasureChest(id=" + this.getId() + ", name=" + this.getName() + ", location=" + String.valueOf(this.getLocation()) + ", pushbackEnabled=" + this.isPushbackEnabled() + ", pushbackStrength=" + this.getPushbackStrength() + ", hologramEnabled=" + this.isHologramEnabled() + ", hologramLines=" + String.valueOf(this.getHologramLines()) + ", hologramHeight=" + this.getHologramHeight() + ", cooldownMillis=" + this.getCooldownMillis() + ", permission=" + this.getPermission() + ", size=" + this.getSize() + ", items=" + String.valueOf(this.getItems()) + ", particleType=" + String.valueOf((Object)this.getParticleType()) + ", particleDisplay=" + String.valueOf(this.getParticleDisplay()) + ", particleEnabled=" + this.isParticleEnabled() + ", particleEffectId=" + String.valueOf(this.getParticleEffectId()) + ", hologramId=" + this.getHologramId() + ", hologramUpdateTask=" + String.valueOf(this.getHologramUpdateTask()) + ")";
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setLocation(Location location) {
        this.location = location;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public void setPushbackEnabled(boolean pushbackEnabled) {
        this.pushbackEnabled = pushbackEnabled;
    }

    @Generated
    public boolean isPushbackEnabled() {
        return this.pushbackEnabled;
    }

    @Generated
    public void setPushbackStrength(double pushbackStrength) {
        this.pushbackStrength = pushbackStrength;
    }

    @Generated
    public double getPushbackStrength() {
        return this.pushbackStrength;
    }

    @Generated
    public void setHologramEnabled(boolean hologramEnabled) {
        this.hologramEnabled = hologramEnabled;
    }

    @Generated
    public boolean isHologramEnabled() {
        return this.hologramEnabled;
    }

    @Generated
    public void setHologramLines(List<String> hologramLines) {
        this.hologramLines = hologramLines;
    }

    @Generated
    public List<String> getHologramLines() {
        return this.hologramLines;
    }

    @Generated
    public void setHologramHeight(double hologramHeight) {
        this.hologramHeight = hologramHeight;
    }

    @Generated
    public double getHologramHeight() {
        return this.hologramHeight;
    }

    @Generated
    public void setCooldownMillis(long cooldownMillis) {
        this.cooldownMillis = cooldownMillis;
    }

    @Generated
    public long getCooldownMillis() {
        return this.cooldownMillis;
    }

    @Generated
    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public void setSize(int size) {
        this.size = size;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public void setItems(List<ItemStack> items) {
        this.items = items;
    }

    @Generated
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Generated
    public ParticleTypes getParticleType() {
        return this.particleType;
    }

    @Generated
    public void setParticleType(ParticleTypes particleType) {
        this.particleType = particleType;
    }

    @Generated
    public Particle getParticleDisplay() {
        return this.particleDisplay;
    }

    @Generated
    public void setParticleDisplay(Particle particleDisplay) {
        this.particleDisplay = particleDisplay;
    }

    @Generated
    public boolean isParticleEnabled() {
        return this.particleEnabled;
    }

    @Generated
    public void setParticleEnabled(boolean particleEnabled) {
        this.particleEnabled = particleEnabled;
    }

    @Generated
    public static class TreasureChestBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private Location location;
        @Generated
        private boolean pushbackEnabled;
        @Generated
        private double pushbackStrength;
        @Generated
        private boolean hologramEnabled;
        @Generated
        private List<String> hologramLines;
        @Generated
        private double hologramHeight;
        @Generated
        private long cooldownMillis;
        @Generated
        private String permission;
        @Generated
        private int size;
        @Generated
        private List<ItemStack> items;
        @Generated
        private ParticleTypes particleType;
        @Generated
        private Particle particleDisplay;
        @Generated
        private boolean particleEnabled;
        @Generated
        private UUID particleEffectId;
        @Generated
        private String hologramId;
        @Generated
        private MyScheduledTask hologramUpdateTask;

        @Generated
        TreasureChestBuilder() {
        }

        @Generated
        public TreasureChestBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public TreasureChestBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public TreasureChestBuilder location(Location location) {
            this.location = location;
            return this;
        }

        @Generated
        public TreasureChestBuilder pushbackEnabled(boolean pushbackEnabled) {
            this.pushbackEnabled = pushbackEnabled;
            return this;
        }

        @Generated
        public TreasureChestBuilder pushbackStrength(double pushbackStrength) {
            this.pushbackStrength = pushbackStrength;
            return this;
        }

        @Generated
        public TreasureChestBuilder hologramEnabled(boolean hologramEnabled) {
            this.hologramEnabled = hologramEnabled;
            return this;
        }

        @Generated
        public TreasureChestBuilder hologramLines(List<String> hologramLines) {
            this.hologramLines = hologramLines;
            return this;
        }

        @Generated
        public TreasureChestBuilder hologramHeight(double hologramHeight) {
            this.hologramHeight = hologramHeight;
            return this;
        }

        @Generated
        public TreasureChestBuilder cooldownMillis(long cooldownMillis) {
            this.cooldownMillis = cooldownMillis;
            return this;
        }

        @Generated
        public TreasureChestBuilder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Generated
        public TreasureChestBuilder size(int size) {
            this.size = size;
            return this;
        }

        @Generated
        public TreasureChestBuilder items(List<ItemStack> items) {
            this.items = items;
            return this;
        }

        @Generated
        public TreasureChestBuilder particleType(ParticleTypes particleType) {
            this.particleType = particleType;
            return this;
        }

        @Generated
        public TreasureChestBuilder particleDisplay(Particle particleDisplay) {
            this.particleDisplay = particleDisplay;
            return this;
        }

        @Generated
        public TreasureChestBuilder particleEnabled(boolean particleEnabled) {
            this.particleEnabled = particleEnabled;
            return this;
        }

        @Generated
        public TreasureChestBuilder particleEffectId(UUID particleEffectId) {
            this.particleEffectId = particleEffectId;
            return this;
        }

        @Generated
        public TreasureChestBuilder hologramId(String hologramId) {
            this.hologramId = hologramId;
            return this;
        }

        @Generated
        public TreasureChestBuilder hologramUpdateTask(MyScheduledTask hologramUpdateTask) {
            this.hologramUpdateTask = hologramUpdateTask;
            return this;
        }

        @Generated
        public TreasureChest build() {
            return new TreasureChest(this.id, this.name, this.location, this.pushbackEnabled, this.pushbackStrength, this.hologramEnabled, this.hologramLines, this.hologramHeight, this.cooldownMillis, this.permission, this.size, this.items, this.particleType, this.particleDisplay, this.particleEnabled, this.particleEffectId, this.hologramId, this.hologramUpdateTask);
        }

        @Generated
        public String toString() {
            return "TreasureChest.TreasureChestBuilder(id=" + this.id + ", name=" + this.name + ", location=" + String.valueOf(this.location) + ", pushbackEnabled=" + this.pushbackEnabled + ", pushbackStrength=" + this.pushbackStrength + ", hologramEnabled=" + this.hologramEnabled + ", hologramLines=" + String.valueOf(this.hologramLines) + ", hologramHeight=" + this.hologramHeight + ", cooldownMillis=" + this.cooldownMillis + ", permission=" + this.permission + ", size=" + this.size + ", items=" + String.valueOf(this.items) + ", particleType=" + String.valueOf((Object)this.particleType) + ", particleDisplay=" + String.valueOf(this.particleDisplay) + ", particleEnabled=" + this.particleEnabled + ", particleEffectId=" + String.valueOf(this.particleEffectId) + ", hologramId=" + this.hologramId + ", hologramUpdateTask=" + String.valueOf(this.hologramUpdateTask) + ")";
        }
    }
}

