/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.particles;

import com.mongenscave.mctreasure.data.ParticleEffectConfiguration;
import com.mongenscave.mctreasure.interfaces.ParticleEffect;
import lombok.Generated;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;

public abstract class AbstractParticleEffect
implements ParticleEffect,
Cloneable {
    protected ParticleEffectConfiguration config = new ParticleEffectConfiguration();
    protected int ticks = 0;
    protected boolean complete = false;

    @Override
    public boolean isComplete() {
        if (this.config.getDuration() > 0 && this.ticks >= this.config.getDuration()) {
            return true;
        }
        return this.complete;
    }

    @Override
    public void update() {
        ++this.ticks;
    }

    protected void spawnParticle(Location location, Particle particle, double extra) {
        if (location == null || location.getWorld() == null || particle == null) {
            return;
        }
        if (this.config.isVisibleToAll()) {
            location.getWorld().spawnParticle(particle, location, 1, 0.0, 0.0, 0.0, extra);
        } else if (this.config.getPlayer() != null && this.config.getPlayer().isOnline()) {
            Player player = this.config.getPlayer();
            player.spawnParticle(particle, location, 1, 0.0, 0.0, 0.0, extra);
        }
    }

    protected void spawnDustParticle(Location location, Color color, float size) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        Particle.DustOptions dustOptions = new Particle.DustOptions(color, size);
        if (this.config.isVisibleToAll()) {
            location.getWorld().spawnParticle(Particle.DUST, location, 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
        } else if (this.config.getPlayer() != null && this.config.getPlayer().isOnline()) {
            Player player = this.config.getPlayer();
            player.spawnParticle(Particle.DUST, location, 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
        }
    }

    protected Location createLocation(double x, double y, double z) {
        Location origin = this.config.getLocation();
        if (origin == null) {
            return null;
        }
        return new Location(origin.getWorld(), origin.getX() + x, origin.getY() + y, origin.getZ() + z);
    }

    @Override
    public abstract AbstractParticleEffect clone();

    @Override
    @Generated
    public ParticleEffectConfiguration getConfig() {
        return this.config;
    }

    @Override
    @Generated
    public void setConfig(ParticleEffectConfiguration config) {
        this.config = config;
    }
}

