/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.particles;

import com.mongenscave.mctreasure.McTreasure;
import com.mongenscave.mctreasure.data.ParticleEffectConfiguration;
import com.mongenscave.mctreasure.identifiers.ParticleTypes;
import com.mongenscave.mctreasure.interfaces.ParticleEffect;
import com.mongenscave.mctreasure.particles.models.Heart;
import com.mongenscave.mctreasure.particles.models.Helix;
import com.mongenscave.mctreasure.particles.models.Pulsar;
import com.mongenscave.mctreasure.particles.models.Sphere;
import com.mongenscave.mctreasure.particles.models.Tornado;
import com.mongenscave.mctreasure.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.mongenscave.mctreasure.utils.LoggerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class ParticleSystem {
    private static ParticleSystem instance;
    private final McTreasure plugin = McTreasure.getInstance();
    private final ConcurrentHashMap<ParticleTypes, ParticleEffect> registeredEffects = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, ParticleEffect> activeEffects = new ConcurrentHashMap();
    private boolean isRunning = false;
    private MyScheduledTask taskRunner;

    public ParticleSystem() {
        this.registerDefaultEffects();
        this.start();
    }

    public static ParticleSystem getInstance() {
        if (instance == null) {
            instance = new ParticleSystem();
        }
        return instance;
    }

    public void reload() {
        this.stopAllEffects();
        this.registeredEffects.clear();
        this.registerDefaultEffects();
        this.start();
    }

    public void shutdown() {
        this.stopAllEffects();
        this.isRunning = false;
        instance = null;
    }

    public void registerEffect(@NotNull ParticleTypes type, ParticleEffect effect) {
        this.registeredEffects.put(type, effect);
    }

    public ParticleEffect getEffect(@NotNull ParticleTypes types) {
        return this.registeredEffects.get((Object)types);
    }

    public UUID startEffect(ParticleTypes types, ParticleEffectConfiguration config) {
        ParticleEffect effect = this.getEffect(types);
        if (effect == null) {
            LoggerUtils.warn("Tried to start unknown particle effect: " + types.name(), new Object[0]);
            return null;
        }
        if (config == null) {
            LoggerUtils.warn("Particle effect configuration cannot be null", new Object[0]);
            return null;
        }
        ParticleEffect clonedEffect = effect.clone();
        clonedEffect.setConfig(config);
        UUID effectUUID = UUID.randomUUID();
        this.activeEffects.put(effectUUID, clonedEffect);
        if (!this.isRunning) {
            this.start();
        }
        return effectUUID;
    }

    public void stopEffect(UUID effectId) {
        if (effectId == null) {
            return;
        }
        this.activeEffects.remove(effectId);
        if (this.activeEffects.isEmpty() && this.isRunning) {
            this.stop();
        }
    }

    public void stopAllEffects() {
        this.activeEffects.clear();
        this.stop();
    }

    private void start() {
        if (this.isRunning) {
            return;
        }
        this.taskRunner = this.plugin.getScheduler().runTaskTimer(this::tick, 0L, 1L);
        this.isRunning = true;
    }

    private void stop() {
        if (!this.isRunning) {
            return;
        }
        if (this.taskRunner != null) {
            this.taskRunner.cancel();
            this.taskRunner = null;
        }
        this.isRunning = false;
    }

    private void tick() {
        List<UUID> toRemove = Collections.synchronizedList(new ArrayList());
        for (Map.Entry<UUID, ParticleEffect> entry : this.activeEffects.entrySet()) {
            UUID effectId = entry.getKey();
            ParticleEffect effect = entry.getValue();
            if (effect == null) {
                toRemove.add(effectId);
                continue;
            }
            try {
                if (effect.isComplete()) {
                    toRemove.add(effectId);
                    continue;
                }
                effect.update();
                effect.display();
            }
            catch (Exception exception) {
                LoggerUtils.error("Error updating particle effect: " + exception.getMessage(), new Object[0]);
                toRemove.add(effectId);
            }
        }
        for (UUID uuid : toRemove) {
            this.activeEffects.remove(uuid);
        }
        if (this.activeEffects.isEmpty() && this.isRunning) {
            this.stop();
        }
    }

    private void registerDefaultEffects() {
        this.registerEffect(ParticleTypes.HEART, new Heart());
        this.registerEffect(ParticleTypes.HELIX, new Helix());
        this.registerEffect(ParticleTypes.PULSAR, new Pulsar());
        this.registerEffect(ParticleTypes.TORNADO, new Tornado());
        this.registerEffect(ParticleTypes.SPHERE, new Sphere());
        LoggerUtils.info("Registered " + this.registeredEffects.size() + " particle effects.", new Object[0]);
    }

    @Generated
    public ConcurrentHashMap<ParticleTypes, ParticleEffect> getRegisteredEffects() {
        return this.registeredEffects;
    }
}

