/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.particles.models;

import com.mongenscave.mctreasure.data.ParticleEffectConfiguration;
import com.mongenscave.mctreasure.particles.AbstractParticleEffect;
import org.bukkit.Location;
import org.bukkit.Particle;

public class Heart
extends AbstractParticleEffect {
    private static final double MAX_SIZE = 1.0;
    private static final double GROWTH_RATE = 0.05;
    private double size = 0.0;

    @Override
    public void update() {
        super.update();
        this.size += 0.05 * this.config.getExpansionRate();
        if (this.size >= 1.0) {
            this.size = 0.0;
        }
    }

    @Override
    public void display() {
        Location center = this.config.getLocation();
        if (center == null) {
            return;
        }
        double radius = this.config.getRadius() * this.size;
        double scale = radius / 1.0;
        for (double t = 0.0; t <= Math.PI * 2; t += 0.19634954084936207) {
            double y;
            double x = scale * 16.0 * Math.pow(Math.sin(t), 3.0);
            Location particleLoc = this.createLocation(x, y = scale * (13.0 * Math.cos(t) - 5.0 * Math.cos(2.0 * t) - 2.0 * Math.cos(3.0 * t) - Math.cos(4.0 * t)), 0.0);
            if (particleLoc == null) continue;
            if (this.config.getParticleType() == Particle.DUST) {
                this.spawnDustParticle(particleLoc, this.config.getParticleColor(), this.config.getParticleSize());
                continue;
            }
            this.spawnParticle(particleLoc, this.config.getParticleType(), this.config.getParticleSpeed());
        }
    }

    @Override
    public Heart clone() {
        Heart clone = new Heart();
        ParticleEffectConfiguration newConfig = new ParticleEffectConfiguration();
        newConfig.copyFrom(this.config);
        clone.setConfig(newConfig);
        return clone;
    }
}

