/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.particles.models;

import com.mongenscave.mctreasure.data.ParticleEffectConfiguration;
import com.mongenscave.mctreasure.particles.AbstractParticleEffect;
import org.bukkit.Location;
import org.bukkit.Particle;

public class Helix
extends AbstractParticleEffect {
    private double angle = 0.0;

    @Override
    public void update() {
        super.update();
        this.angle += this.config.getRotationSpeed() * 0.1;
        if (this.angle >= 360.0) {
            this.angle = 0.0;
        }
    }

    @Override
    public void display() {
        Location center = this.config.getLocation();
        if (center == null) {
            return;
        }
        double radius = this.config.getRadius();
        double height = this.config.getHeight();
        int density = this.config.getDensity();
        for (double y = 0.0; y <= height; y += height / (double)density) {
            double x1 = radius * Math.cos(this.angle + y * 2.0 * Math.PI / height);
            double z1 = radius * Math.sin(this.angle + y * 2.0 * Math.PI / height);
            double x2 = radius * Math.cos(this.angle + Math.PI + y * 2.0 * Math.PI / height);
            double z2 = radius * Math.sin(this.angle + Math.PI + y * 2.0 * Math.PI / height);
            Location particleLoc1 = this.createLocation(x1, y, z1);
            Location particleLoc2 = this.createLocation(x2, y, z2);
            if (particleLoc1 != null) {
                if (this.config.getParticleType() == Particle.DUST) {
                    this.spawnDustParticle(particleLoc1, this.config.getParticleColor(), this.config.getParticleSize());
                } else {
                    this.spawnParticle(particleLoc1, this.config.getParticleType(), this.config.getParticleSpeed());
                }
            }
            if (particleLoc2 == null) continue;
            if (this.config.getParticleType() == Particle.DUST) {
                this.spawnDustParticle(particleLoc2, this.config.getParticleColor(), this.config.getParticleSize());
                continue;
            }
            this.spawnParticle(particleLoc2, this.config.getParticleType(), this.config.getParticleSpeed());
        }
    }

    @Override
    public Helix clone() {
        Helix clone = new Helix();
        ParticleEffectConfiguration newConfig = new ParticleEffectConfiguration();
        newConfig.copyFrom(this.config);
        clone.setConfig(newConfig);
        return clone;
    }
}

