/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.particles.models;

import com.mongenscave.mctreasure.data.ParticleEffectConfiguration;
import com.mongenscave.mctreasure.particles.AbstractParticleEffect;
import org.bukkit.Location;
import org.bukkit.Particle;

public class Pulsar
extends AbstractParticleEffect {
    private double pulseRadius = 0.0;
    private boolean expanding = true;

    @Override
    public void update() {
        super.update();
        if (this.expanding) {
            this.pulseRadius += this.config.getExpansionRate() * 0.1;
            if (this.pulseRadius >= this.config.getRadius()) {
                this.expanding = false;
            }
        } else {
            this.pulseRadius -= this.config.getExpansionRate() * 0.1;
            if (this.pulseRadius <= 0.0) {
                this.expanding = true;
            }
        }
    }

    @Override
    public void display() {
        Location center = this.config.getLocation();
        if (center == null) {
            return;
        }
        int density = this.config.getDensity();
        for (int i = 0; i < density; ++i) {
            double y;
            Location particleLoc2;
            double z;
            double angle = (double)(i * 2) * Math.PI / (double)density;
            double x = this.pulseRadius * Math.cos(angle);
            Location particleLoc = this.createLocation(x, 0.0, z = this.pulseRadius * Math.sin(angle));
            if (particleLoc != null) {
                if (this.config.getParticleType() == Particle.DUST) {
                    this.spawnDustParticle(particleLoc, this.config.getParticleColor(), this.config.getParticleSize());
                } else {
                    this.spawnParticle(particleLoc, this.config.getParticleType(), this.config.getParticleSpeed());
                }
            }
            if ((particleLoc2 = this.createLocation(x, y = this.pulseRadius * Math.sin(angle) * 0.5, z)) == null) continue;
            if (this.config.getParticleType() == Particle.DUST) {
                this.spawnDustParticle(particleLoc2, this.config.getParticleColor(), this.config.getParticleSize());
                continue;
            }
            this.spawnParticle(particleLoc2, this.config.getParticleType(), this.config.getParticleSpeed());
        }
    }

    @Override
    public Pulsar clone() {
        Pulsar clone = new Pulsar();
        ParticleEffectConfiguration newConfig = new ParticleEffectConfiguration();
        newConfig.copyFrom(this.config);
        clone.setConfig(newConfig);
        return clone;
    }
}

