/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.particles.models;

import com.mongenscave.mctreasure.data.ParticleEffectConfiguration;
import com.mongenscave.mctreasure.particles.AbstractParticleEffect;
import org.bukkit.Location;
import org.bukkit.Particle;

public class Sphere
extends AbstractParticleEffect {
    private double rotationX = 0.0;
    private double rotationY = 0.0;

    @Override
    public void update() {
        super.update();
        this.rotationX += this.config.getRotationSpeed() * 0.05;
        this.rotationY += this.config.getRotationSpeed() * 0.03;
        if (this.rotationX >= 360.0) {
            this.rotationX = 0.0;
        }
        if (this.rotationY >= 360.0) {
            this.rotationY = 0.0;
        }
    }

    @Override
    public void display() {
        Location center = this.config.getLocation();
        if (center == null) {
            return;
        }
        double radius = this.config.getRadius();
        int density = Math.max(3, this.config.getDensity() / 2);
        for (int i = 0; i < density; ++i) {
            double phi = Math.acos(-1.0 + 2.0 * (double)i / (double)density);
            for (int j = 0; j < density; ++j) {
                double theta = Math.PI * 2 * (double)j / (double)density;
                double x = radius * Math.sin(phi) * Math.cos(theta);
                double y = radius * Math.sin(phi) * Math.sin(theta);
                double z = radius * Math.cos(phi);
                double newX = x * Math.cos(this.rotationX) - z * Math.sin(this.rotationX);
                double newZ = x * Math.sin(this.rotationX) + z * Math.cos(this.rotationX);
                double newY = y * Math.cos(this.rotationY) - newZ * Math.sin(this.rotationY);
                Location particleLoc = this.createLocation(newX, newY, newZ = y * Math.sin(this.rotationY) + newZ * Math.cos(this.rotationY));
                if (particleLoc == null) continue;
                if (this.config.getParticleType() == Particle.DUST) {
                    this.spawnDustParticle(particleLoc, this.config.getParticleColor(), this.config.getParticleSize());
                    continue;
                }
                this.spawnParticle(particleLoc, this.config.getParticleType(), this.config.getParticleSpeed());
            }
        }
    }

    @Override
    public Sphere clone() {
        Sphere clone = new Sphere();
        ParticleEffectConfiguration newConfig = new ParticleEffectConfiguration();
        newConfig.copyFrom(this.config);
        clone.setConfig(newConfig);
        return clone;
    }
}

