/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.particles.models;

import com.mongenscave.mctreasure.data.ParticleEffectConfiguration;
import com.mongenscave.mctreasure.particles.AbstractParticleEffect;
import org.bukkit.Location;
import org.bukkit.Particle;

public class Tornado
extends AbstractParticleEffect {
    private double angle = 0.0;
    private double height = 0.0;
    private boolean ascending = true;

    @Override
    public void update() {
        super.update();
        this.angle += this.config.getRotationSpeed() * 0.2;
        if (this.angle >= 360.0) {
            this.angle = 0.0;
        }
        if (this.ascending) {
            this.height += 0.1;
            if (this.height >= this.config.getHeight()) {
                this.ascending = false;
            }
        } else {
            this.height -= 0.1;
            if (this.height <= 0.0) {
                this.ascending = true;
            }
        }
    }

    @Override
    public void display() {
        Location center = this.config.getLocation();
        if (center == null) {
            return;
        }
        double maxHeight = this.config.getHeight();
        int density = this.config.getDensity();
        for (double y = 0.0; y <= maxHeight; y += maxHeight / (double)density) {
            double radiusAtHeight = this.config.getRadius() * (1.0 - y / maxHeight);
            for (int i = 0; i < 8; ++i) {
                double z;
                double circleAngle = this.angle + (double)i * Math.PI / 4.0;
                double x = radiusAtHeight * Math.cos(circleAngle);
                Location particleLoc = this.createLocation(x, y + this.height % maxHeight, z = radiusAtHeight * Math.sin(circleAngle));
                if (particleLoc == null) continue;
                if (this.config.getParticleType() == Particle.DUST) {
                    this.spawnDustParticle(particleLoc, this.config.getParticleColor(), this.config.getParticleSize());
                    continue;
                }
                this.spawnParticle(particleLoc, this.config.getParticleType(), this.config.getParticleSpeed());
            }
        }
    }

    @Override
    public Tornado clone() {
        Tornado clone = new Tornado();
        ParticleEffectConfiguration newConfig = new ParticleEffectConfiguration();
        newConfig.copyFrom(this.config);
        clone.setConfig(newConfig);
        return clone;
    }
}

