/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.processor;

import com.mongenscave.mctreasure.McTreasure;
import com.mongenscave.mctreasure.gui.Menu;
import com.mongenscave.mctreasure.universalScheduler.scheduling.tasks.MyScheduledTask;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public class MenuProcessor {
    private final Menu menu;
    private MyScheduledTask task;

    public MenuProcessor(@NotNull Menu menu) {
        this.menu = menu;
    }

    public void start(int intervalTicks) {
        if (this.isRunning()) {
            return;
        }
        this.task = McTreasure.getInstance().getScheduler().runTaskTimer(this::updateMenu, (long)intervalTicks, (long)intervalTicks);
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    private void updateMenu() {
        Inventory inv = this.menu.getInventory();
        if (inv == null) {
            this.stop();
            return;
        }
        if (inv.getViewers().contains(this.menu.menuController.owner())) {
            this.menu.updateMenuItems();
        } else {
            this.stop();
        }
    }

    public boolean isRunning() {
        return this.task != null && !this.task.isCancelled();
    }
}

