/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.processor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessageProcessor {
    private static final char COLOR_CHAR = '\u00a7';
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");

    @NotNull
    public static String process(@Nullable String message) {
        if (message == null) {
            return "";
        }
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuilder builder = new StringBuilder(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(builder, "\u00a7x\u00a7" + group.charAt(0) + "\u00a7" + group.charAt(1) + "\u00a7" + group.charAt(2) + "\u00a7" + group.charAt(3) + "\u00a7" + group.charAt(4) + "\u00a7" + group.charAt(5));
        }
        String hexProcessed = matcher.appendTail(builder).toString();
        return ChatColor.translateAlternateColorCodes((char)'&', (String)hexProcessed);
    }

    @Generated
    private MessageProcessor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

