/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.utils;

import com.mongenscave.mctreasure.utils.LoggerUtils;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocationUtils {
    @NotNull
    public static String serialize(@NotNull Location location) {
        return location.getWorld().getName() + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
    }

    @Nullable
    public static Location deserialize(@NotNull String serializedLocation) {
        String[] parts = serializedLocation.split(",");
        if (parts.length != 4) {
            return null;
        }
        try {
            return new Location(Bukkit.getWorld((String)parts[0]), (double)Integer.parseInt(parts[1]), (double)Integer.parseInt(parts[2]), (double)Integer.parseInt(parts[3]));
        }
        catch (Exception exception) {
            LoggerUtils.error("Could not deserialize location: " + serializedLocation, new Object[0]);
            return null;
        }
    }

    @Generated
    private LocationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

