/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.zapper;

import com.mongenscave.mctreasure.zapper.DependencyDownloadResult;
import com.mongenscave.mctreasure.zapper.repository.Repository;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;

public final class Dependency {
    private static final String MAVEN_PATH = "%s/%s/%s/%s-%s.jar";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String mavenPath;

    public Dependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.mavenPath = String.format(MAVEN_PATH, this.groupId.replace('.', '/'), this.artifactId, this.version, this.artifactId, this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency that = (Dependency)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version);
    }

    @CheckReturnValue
    @NotNull
    public DependencyDownloadResult download(@NotNull File file, @NotNull Repository repository) {
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            URL url = repository.resolve(this);
            try (InputStream depIn = url.openStream();
                 OutputStream outStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = depIn.read(buffer)) != -1) {
                    outStream.write(buffer, 0, bytesRead);
                }
            }
            return DependencyDownloadResult.success();
        }
        catch (Throwable t) {
            file.delete();
            return DependencyDownloadResult.failure(t);
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMavenPath() {
        return this.mavenPath;
    }
}

