/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.zapper;

import com.mongenscave.mctreasure.zapper.Dependency;
import com.mongenscave.mctreasure.zapper.DependencyDownloadException;
import com.mongenscave.mctreasure.zapper.DependencyDownloadResult;
import com.mongenscave.mctreasure.zapper.DependencyScope;
import com.mongenscave.mctreasure.zapper.classloader.URLClassLoaderWrapper;
import com.mongenscave.mctreasure.zapper.relocation.Relocation;
import com.mongenscave.mctreasure.zapper.relocation.Relocator;
import com.mongenscave.mctreasure.zapper.repository.Repository;
import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public final class DependencyManager
implements DependencyScope {
    public static boolean FAILED_TO_DOWNLOAD = false;
    private static final Pattern COLON = Pattern.compile(":");
    private final File directory;
    private final URLClassLoaderWrapper loaderWrapper;
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final Set<Repository> repositories = new LinkedHashSet<Repository>();
    private final List<Relocation> relocations = new ArrayList<Relocation>();

    public DependencyManager(@NotNull File directory, @NotNull URLClassLoaderWrapper loaderWrapper) {
        this.directory = directory;
        this.loaderWrapper = loaderWrapper;
        this.repositories.add(Repository.mavenCentral());
    }

    public void load() {
        try {
            for (Dependency dep : this.dependencies) {
                File file = new File(this.directory, String.format("%s.%s-%s.jar", dep.getGroupId(), dep.getArtifactId(), dep.getVersion()));
                File relocated = new File(this.directory, String.format("%s.%s-%s-relocated.jar", dep.getGroupId(), dep.getArtifactId(), dep.getVersion()));
                if (this.hasRelocations() && relocated.exists()) {
                    this.loaderWrapper.addURL(relocated.toURI().toURL());
                    continue;
                }
                if (!file.exists()) {
                    boolean succeeded = false;
                    ArrayList<String> failedRepos = null;
                    for (Repository repository : this.repositories) {
                        DependencyDownloadResult result = dep.download(file, repository);
                        if (result.wasSuccessful()) {
                            succeeded = true;
                            break;
                        }
                        (failedRepos == null ? new ArrayList<String>() : failedRepos).add(repository.toString());
                    }
                    if (failedRepos != null && !succeeded) {
                        throw new DependencyDownloadException(dep, "Could not find dependency in any of the following repositories: " + String.join((CharSequence)"\n", failedRepos));
                    }
                }
                if (this.hasRelocations() && !relocated.exists()) {
                    Relocator.relocate(file, relocated, this.relocations);
                    file.delete();
                }
                if (this.hasRelocations()) {
                    this.loaderWrapper.addURL(relocated.toURI().toURL());
                    continue;
                }
                this.loaderWrapper.addURL(file.toURI().toURL());
            }
        }
        catch (DependencyDownloadException e) {
            if (e.getCause() instanceof UnknownHostException) {
                Bukkit.getLogger().info("[Zapper] It appears you do not have an internet connection. Extract the zip in https://bit.ly/3cd3wGe at /Zapper/libraries.");
                FAILED_TO_DOWNLOAD = true;
            }
            throw e;
        }
        catch (RuntimeException d) {
            throw d;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void dependency(@NotNull Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public void dependency(@NotNull String dependency) {
        String[] parts = COLON.split(dependency);
        this.dependencies.add(new Dependency(parts[0], parts[1], parts[2]));
    }

    public void dependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        this.dependencies.add(new Dependency(groupId, artifactId, version));
    }

    public void relocate(@NotNull Relocation relocation) {
        this.relocations.add(relocation);
    }

    public void repository(@NotNull Repository repository) {
        this.repositories.add(repository);
    }

    public boolean hasRelocations() {
        return !this.relocations.isEmpty();
    }
}

