/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mctreasure.zapper.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassLoaderReader {
    private static final Field description;
    private static final Field dataFolder;
    private static final Class<? extends URLClassLoader> PL_CL_LOADER;

    private ClassLoaderReader() {
    }

    @NotNull
    public static PluginDescriptionFile getDescription(@NotNull Class<?> cl) {
        ClassLoader classLoader = cl.getClassLoader();
        if (!PL_CL_LOADER.isAssignableFrom(classLoader.getClass())) {
            throw new UnsupportedOperationException("Class is not a plugin class");
        }
        try {
            return (PluginDescriptionFile)description.get(classLoader);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static File getDataFolder(@NotNull Class<?> cl) {
        ClassLoader classLoader = cl.getClassLoader();
        if (!PL_CL_LOADER.isAssignableFrom(classLoader.getClass())) {
            throw new UnsupportedOperationException("Class is not a plugin class");
        }
        try {
            return (File)dataFolder.get(classLoader);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Contract(value="null -> fail")
    @Nullable
    public static InputStream getResource(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("File name cannot be null");
        }
        try {
            URL url = ClassLoaderReader.class.getClassLoader().getResource(fileName);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    static {
        try {
            PL_CL_LOADER = Class.forName("org.bukkit.plugin.java.PluginClassLoader").asSubclass(URLClassLoader.class);
            description = PL_CL_LOADER.getDeclaredField("description");
            description.setAccessible(true);
            dataFolder = PL_CL_LOADER.getDeclaredField("dataFolder");
            dataFolder.setAccessible(true);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

