/*
 * Decompiled with CFR 0.152.
 */
package leaf.cosmere.feruchemy.common.config;

import leaf.cosmere.common.config.ICosmereConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class FeruchemyServerConfig
implements ICosmereConfig {
    private final ForgeConfigSpec configSpec;
    public final ForgeConfigSpec.IntValue BENDALLOY_SATURATION_MULTIPLIER;
    public final ForgeConfigSpec.IntValue GOLD_TAP_COST_MULTIPLIER;
    public final ForgeConfigSpec.IntValue GOD_METAL_EAT_STRENGTH_MINIMUM;
    public final ForgeConfigSpec.IntValue FULL_FERUCHEMIST_STARTING_METALMIND_COUNT;
    public final ForgeConfigSpec.DoubleValue STARTING_METALMIND_RANDOMISED_MAX_FILL_AMOUNT;

    FeruchemyServerConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Feruchemy Config. This config is synced between server and client.").push("feruchemy");
        this.BENDALLOY_SATURATION_MULTIPLIER = builder.comment("The cost multiplier for when player is full and needs to start doing saturation").defineInRange("bendalloySaturationMultiplier", 2, 1, Integer.MAX_VALUE);
        this.GOLD_TAP_COST_MULTIPLIER = builder.comment("Healing cost multiplier for tapping").defineInRange("goldTapCostMultiplier", 2, 1, Integer.MAX_VALUE);
        this.GOD_METAL_EAT_STRENGTH_MINIMUM = builder.comment("When the user eats a lerasatium nugget, what should their strength in feruchemy be set to").defineInRange("godMetalMinimumStrength", 16, 1, 32);
        this.FULL_FERUCHEMIST_STARTING_METALMIND_COUNT = builder.comment("How many metalminds should a full feruchemist start with?").defineInRange("fullFeruchemistStartingMetalmindCount", 3, 0, 16);
        this.STARTING_METALMIND_RANDOMISED_MAX_FILL_AMOUNT = builder.comment("What is the max amount a starting metalmind can be filled with attribute? The value is randomised, with this set as the max.").defineInRange("fullFeruchemistStartingMetalmindFillAmount", 0.6667, 0.0, 1.0);
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "FeruchemyServer";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }

    public void clearCache() {
        this.BENDALLOY_SATURATION_MULTIPLIER.clearCache();
        this.GOLD_TAP_COST_MULTIPLIER.clearCache();
        this.GOD_METAL_EAT_STRENGTH_MINIMUM.clearCache();
        this.FULL_FERUCHEMIST_STARTING_METALMIND_COUNT.clearCache();
        this.STARTING_METALMIND_RANDOMISED_MAX_FILL_AMOUNT.clearCache();
    }
}

